/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.admin.jmx;

import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import net.stax.appserver.admin.jmx.MBeanAttrs;
import net.stax.appserver.admin.jmx.MBeanInfoResource;
import net.stax.appserver.admin.jmx.MBeanName;
import net.stax.appserver.admin.jmx.MBeanParams;
import net.stax.appserver.admin.jmx.NotFoundException;

public class MBeanContainerResource {
    public Collection<MBeanName> getMBeans() throws Exception {
        List<MBeanServer> servers = this.getMBeanServers();
        LinkedList<MBeanName> list = new LinkedList<MBeanName>();
        for (MBeanServer server : servers) {
            this.addMBeans(server, list, null);
        }
        return list;
    }

    public Collection<MBeanName> getMBeans(String query) throws Exception {
        List<MBeanServer> servers = this.getMBeanServers();
        LinkedList<MBeanName> list = new LinkedList<MBeanName>();
        for (MBeanServer server : servers) {
            this.addMBeans(server, list, query);
        }
        return list;
    }

    private List<MBeanServer> getMBeanServers() {
        LinkedList<MBeanServer> servers = new LinkedList<MBeanServer>();
        servers.add(ManagementFactory.getPlatformMBeanServer());
        servers.addAll(MBeanServerFactory.findMBeanServer(null));
        return servers;
    }

    private void addMBeans(MBeanServer server, Collection<MBeanName> beans, String query) throws Exception {
        HashSet<ObjectName> mbeans = new HashSet<ObjectName>();
        try {
            ObjectName queryName = query != null ? new ObjectName(query) : null;
            mbeans.addAll(server.queryNames(queryName, null));
            for (ObjectName oname : mbeans) {
                String name = oname.toString();
                String agentId = null;
                try {
                    agentId = server.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId").toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                MBeanName resource = new MBeanName(name, agentId);
                beans.add(resource);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MBeanInfoResource getMBeanInfo(String name) throws Exception {
        List<MBeanServer> servers = this.getMBeanServers();
        for (MBeanServer server : servers) {
            try {
                MBeanInfo info = server.getMBeanInfo(new ObjectName(name));
                return new MBeanInfoResource(name, info);
            }
            catch (InstanceNotFoundException e) {
            }
            catch (Exception e) {
                throw e;
            }
        }
        throw new NotFoundException();
    }

    public MBeanAttrs getAttributes(String name) throws Exception {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        List<MBeanServer> servers = this.getMBeanServers();
        for (MBeanServer server : servers) {
            try {
                ObjectName objectName = new ObjectName(name);
                MBeanInfo info = server.getMBeanInfo(objectName);
                for (MBeanAttributeInfo attr : info.getAttributes()) {
                    Object value;
                    if (!attr.isReadable()) continue;
                    String attrName = attr.getName();
                    try {
                        value = server.getAttribute(objectName, attrName);
                    }
                    catch (Exception e) {
                        value = "[error: " + e.getMessage() + "]";
                    }
                    attrs.put(attrName, value);
                }
                return new MBeanAttrs(name, attrs);
            }
            catch (InstanceNotFoundException e) {
            }
            catch (Exception e) {
                throw e;
            }
        }
        throw new NotFoundException();
    }

    public Object getAttribute(String name, String attrName) throws Exception {
        List<MBeanServer> servers = this.getMBeanServers();
        for (MBeanServer server : servers) {
            try {
                ObjectName objectName = new ObjectName(name);
                MBeanInfo info = server.getMBeanInfo(objectName);
                Object value = server.getAttribute(objectName, attrName);
                return value;
            }
            catch (InstanceNotFoundException e) {
            }
            catch (Exception e) {
                throw e;
            }
        }
        throw new NotFoundException();
    }

    public MBeanServer getServerForMBean(String name) throws Exception {
        List<MBeanServer> servers = this.getMBeanServers();
        for (MBeanServer server : servers) {
            try {
                ObjectName objectName = new ObjectName(name);
                MBeanInfo info = server.getMBeanInfo(objectName);
                return server;
            }
            catch (InstanceNotFoundException e) {
            }
            catch (Exception e) {
                throw e;
            }
        }
        throw new InstanceNotFoundException();
    }

    public void setAttributes(String name, MBeanAttrs attrs) throws Exception {
        List<MBeanServer> servers = this.getMBeanServers();
        for (MBeanServer server : servers) {
            try {
                ObjectName objectName = new ObjectName(name);
                server.setAttributes(objectName, MBeanContainerResource.toAttributeList(attrs));
                return;
            }
            catch (InstanceNotFoundException e) {
            }
            catch (Exception e) {
                throw e;
            }
        }
        throw new NotFoundException();
    }

    public void invoke(String name, String operation, MBeanParams params) throws Exception {
        List<MBeanServer> servers = this.getMBeanServers();
        for (MBeanServer server : servers) {
            try {
                ObjectName objectName = new ObjectName(name);
                Object result = server.invoke(objectName, operation, params.getValues(), params.getSignature());
                return;
            }
            catch (InstanceNotFoundException e) {
            }
            catch (Exception e) {
                throw e;
            }
        }
        throw new NotFoundException();
    }

    private static AttributeList toAttributeList(MBeanAttrs attrs) {
        AttributeList list = new AttributeList();
        for (Map.Entry<String, Object> entry : attrs.getAttributes().entrySet()) {
            Attribute attr = new Attribute(entry.getKey(), entry.getValue());
            list.add(attr);
        }
        return list;
    }
}

