/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.admin.jmx;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.stax.appserver.admin.jmx.JSONRestHandler;
import net.stax.appserver.admin.jmx.JSONSerializer;
import net.stax.appserver.admin.jmx.MBeanAttrs;
import net.stax.appserver.admin.jmx.MBeanContainerResource;
import net.stax.appserver.json.JSONObject;

class MBeanHandler
extends JSONRestHandler {
    public MBeanHandler() {
        super("/mbean/(.+)");
    }

    @Override
    void doGet(Matcher matcher, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String mbeanName = matcher.group(1);
        MBeanAttrs attrs = new MBeanContainerResource().getAttributes(mbeanName);
        JSONObject jsonObject = JSONSerializer.toJSON(attrs);
        this.sendJSON(jsonObject, request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doPost(Matcher matcher, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String mbeanName = matcher.group(1);
        BufferedReader reader = request.getReader();
        try {
            MBeanAttrs attrs = JSONSerializer.attrsFromReader(mbeanName, reader);
            new MBeanContainerResource().setAttributes(mbeanName, attrs);
            response.setStatus(200);
        }
        finally {
            ((Reader)reader).close();
        }
    }
}

