/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.webapp;

import com.staxnet.appserver.jmx.ApplicationObjectFactory;
import java.util.logging.Logger;
import net.stax.log.StaxLogging;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.core.StandardContext;

public class LoggingContext
implements ContainerListener {
    private static Logger logger = Logger.getLogger(LoggingContext.class.getName());
    private boolean initialized = false;

    public LoggingContext(String baseUrl, String license, String sourceName) {
        StaxLogging.init((String)baseUrl, (String)license, (String)sourceName);
    }

    public void containerEvent(ContainerEvent evt) {
        StandardContext context = (StandardContext)evt.getContainer();
        if (evt.getType().equals("beforeContextInitialized")) {
            if (!this.initialized) {
                this.initialized = true;
                this.onBeforeContextInitialized(context);
            }
        } else if (!evt.getType().equals("beforeContextDestroyed") && evt.getType().equals("afterContextDestroyed") && this.initialized) {
            this.initialized = false;
            this.onAfterContextDestroyed(context);
        }
    }

    private void onBeforeContextInitialized(StandardContext context) {
        ClassLoader apploader = context.getLoader().getClassLoader();
        ApplicationObjectFactory objectFactory = new ApplicationObjectFactory(apploader);
        try {
            Class<?> log4JManager = apploader.loadClass("org.apache.log4j.LogManager");
            Class<?> log4Appender = objectFactory.loadApplicationClass("net.stax.log.Log4JAppender");
            Class<?> cls = objectFactory.loadApplicationClass("net.stax.log.Log4JDriver");
            StaxLogging.loadLogDriver(cls);
        }
        catch (ClassNotFoundException e) {
            logger.info("Log4J driver was not loaded");
        }
    }

    private void onAfterContextDestroyed(StandardContext context) {
        StaxLogging.stop();
    }
}

