/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.webapp;

import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.ServerCallbackClient;
import com.staxnet.appserver.utils.StreamHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class PrivateApplicationValve
extends ValveBase {
    private IAppServerConfiguration config;
    private ServerCallbackClient serverCallbackClient;
    private Map<String, ServerCallbackClient.AuthenticationResult> authTickets = new HashMap<String, ServerCallbackClient.AuthenticationResult>();

    public PrivateApplicationValve(IAppServerConfiguration config) throws ServletException {
        this.init(config);
    }

    public void init(IAppServerConfiguration config) throws ServletException {
        this.config = config;
        if (this.isEmptyOrNull(config.getServerCallbackAuthToken()) || this.isEmptyOrNull(config.getServerCallbackUrl())) {
            throw new ServletException("Illegal state: cannot use private application without configuring server callbacks");
        }
        this.serverCallbackClient = new ServerCallbackClient(config.getServerCallbackUrl(), config.getServerCallbackAuthToken());
    }

    private boolean isEmptyOrNull(String val) {
        return val == null || val.equals("");
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        String authToken = PrivateApplicationValve.getCookieValue(request.getCookies(), "stax-auth", null);
        if (authToken == null || !this.isAuthenticated(authToken)) {
            String targetUrl = request.getParameter("targetUrl");
            if (targetUrl == null) {
                targetUrl = request.getRequestURI();
            }
            if (request.getParameter("staxauth") != null) {
                String userAuth = this.authenticateUser(request.getParameter("username"), request.getParameter("password"));
                if (userAuth != null) {
                    Cookie cookie = new Cookie("stax-auth", userAuth);
                    cookie.setPath("/");
                    response.addCookie(cookie);
                    response.sendRedirect(request.getParameter("targetUrl"));
                } else {
                    this.displayLoginForm(request, response, targetUrl);
                }
            } else {
                this.displayLoginForm(request, response, targetUrl);
            }
        } else {
            Valve nextValve = this.getNext();
            if (nextValve != null) {
                nextValve.invoke(request, response);
            }
        }
    }

    private String authenticateUser(String username, String password) throws IOException {
        ServerCallbackClient.AuthenticationResult result = this.serverCallbackClient.getApplicationTicket(username, password);
        String authTicket = result.getAuthTicket();
        if (authTicket != null) {
            this.authTickets.put(authTicket, result);
        }
        return authTicket;
    }

    private boolean isAuthenticated(String authToken) throws IOException {
        ServerCallbackClient.AuthenticationResult result = this.authTickets.get(authToken);
        if (result == null) {
            result = this.serverCallbackClient.renewApplicationTicket(authToken);
            String authTicket = result.getAuthTicket();
            if (authTicket != null) {
                this.authTickets.put(authTicket, result);
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayLoginForm(Request request, Response resp, String targetUrl) throws IOException {
        PrintWriter out = resp.getWriter();
        InputStream loginFormIn = ((Object)((Object)this)).getClass().getResourceAsStream("/com/staxnet/appserver/filters/loginForm.htm");
        try {
            String formContent = new String(StreamHelper.readAll(loginFormIn), "utf-8");
            formContent = formContent.replace("${targetUrl}", targetUrl);
            out.println(formContent);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (loginFormIn != null) {
                loginFormIn.close();
            }
        }
    }

    public static String getCookieValue(Cookie[] cookies, String cookieName, String defaultValue) {
        if (cookies == null) {
            return defaultValue;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookieName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return defaultValue;
    }
}

