/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.webapp;

import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.ServerCallbackClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class RequestMonitorValve
extends ValveBase {
    private IAppServerConfiguration serverConfig;
    private IdleTimer idleTimer;
    private ServerCallbackClient serverCallbackClient;

    public RequestMonitorValve(IAppServerConfiguration config) throws ServletException {
        this.init(config);
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.idleTimer.notifyRequestReceived();
        Valve nextValve = this.getNext();
        if (nextValve != null) {
            nextValve.invoke(request, response);
        }
    }

    public void init(IAppServerConfiguration config) throws ServletException {
        if (config.getServerCallbackAuthToken() != null && config.getServerCallbackUrl() != null) {
            this.serverCallbackClient = new ServerCallbackClient(config.getServerCallbackUrl(), config.getServerCallbackAuthToken());
        }
        this.idleTimer = new IdleTimer(config.getStatusInterval(), config.getStatusInterval(), this.serverCallbackClient, new IdleTimeoutHandler(){

            @Override
            public void enterActiveState() {
            }

            @Override
            public void enterIdleState(long idleSeconds) {
            }
        });
        Thread th = new Thread((Runnable)this.idleTimer, "requestMonitor");
        th.start();
    }

    static interface IdleTimeoutHandler {
        public void enterIdleState(long var1);

        public void enterActiveState();
    }

    static class IdleTimer
    implements Runnable {
        public long lastRequestMillis;
        private int idleTimeoutSecs;
        private int statusIntervalSecs;
        private IdleTimeoutHandler timeoutHandler;
        private ServerCallbackClient.State state = ServerCallbackClient.State.ACTIVE;
        private ServerCallbackClient callbackClient;
        private Map<String, Integer> errors = new HashMap<String, Integer>();

        IdleTimer(int idleTimeout, int statusInterval, ServerCallbackClient callbackClient, IdleTimeoutHandler timeoutHandler) {
            if (idleTimeout < statusInterval) {
                throw new IllegalStateException("idleTimeout is less than statusInterval: this leads to time windows that can miss active states");
            }
            this.idleTimeoutSecs = idleTimeout;
            this.statusIntervalSecs = statusInterval;
            this.timeoutHandler = timeoutHandler;
            this.callbackClient = callbackClient;
            this.lastRequestMillis = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyRequestReceived() {
            this.lastRequestMillis = System.currentTimeMillis();
            if (this.state != ServerCallbackClient.State.ACTIVE) {
                IdleTimer idleTimer = this;
                synchronized (idleTimer) {
                    this.setState(ServerCallbackClient.State.ACTIVE);
                }
            }
        }

        private long getIdleSeconds() {
            return (System.currentTimeMillis() - this.lastRequestMillis) / 1000L;
        }

        private void setState(ServerCallbackClient.State state) {
            if (this.state != state) {
                this.state = state;
                if (this.timeoutHandler != null) {
                    if (state == ServerCallbackClient.State.IDLE) {
                        this.timeoutHandler.enterIdleState(this.getIdleSeconds());
                    } else if (state == ServerCallbackClient.State.ACTIVE) {
                        this.timeoutHandler.enterActiveState();
                    } else {
                        throw new IllegalStateException();
                    }
                }
            }
        }

        @Override
        public void run() {
            while (true) {
                block9: {
                    try {
                        long idleSecs = this.getIdleSeconds();
                        if (idleSecs > (long)this.idleTimeoutSecs) {
                            this.setState(ServerCallbackClient.State.IDLE);
                        } else {
                            this.setState(ServerCallbackClient.State.ACTIVE);
                        }
                        if (this.callbackClient != null) {
                            this.callbackClient.updateStatus(this.state);
                        }
                    }
                    catch (Exception e) {
                        Integer errorCount = this.errors.get(e.getClass().getName() + e.getMessage());
                        if (errorCount == null || errorCount < 25) {
                            e.printStackTrace();
                            this.errors.put(e.getClass().getName() + e.getMessage(), errorCount == null ? 1 : errorCount + 1);
                        }
                        if (errorCount != 25) break block9;
                        System.err.println("Error is repeating, and will now be silent: " + e.getMessage());
                        this.errors.put(e.getClass().getName() + e.getMessage(), errorCount == null ? 1 : errorCount + 1);
                    }
                }
                try {
                    Thread.sleep(this.statusIntervalSecs * 1000);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

