/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.webapp;

import com.staxnet.appserver.IAppServerConfiguration;
import com.staxnet.appserver.IEngineFactory;
import com.staxnet.appserver.config.ContextParamConfig;
import com.staxnet.appserver.config.DependencyConfig;
import com.staxnet.appserver.config.HttpConfig;
import com.staxnet.appserver.config.ModuleConfig;
import com.staxnet.appserver.config.ModuleParser;
import com.staxnet.appserver.config.ParamConfig;
import com.staxnet.appserver.config.RealmConfig;
import com.staxnet.appserver.config.ResourceConfig;
import com.staxnet.appserver.config.WebConfig;
import com.staxnet.appserver.session.StaxSessionStore;
import com.staxnet.repository.LocalRepository;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.stax.appserver.admin.StaxApplicationQueryValve;
import net.stax.appserver.webapp.LoggingContext;
import net.stax.appserver.webapp.PrivateApplicationValve;
import net.stax.appserver.webapp.RequestMonitorValve;
import net.stax.appserver.webapp.RequestSetupValve;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Store;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.session.PersistentManager;
import org.apache.catalina.startup.Embedded;
import org.apache.catalina.valves.PersistentValve;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.tomcat.util.IntrospectionUtils;

public class WebAppEngine
implements IEngineFactory {
    protected static Logger logger = Logger.getLogger("WebAppEngine");
    protected boolean CLUSTER_SESSIONS = false;
    private File baseDir;
    private String configurationDir;
    private int port;
    private IAppServerConfiguration appServerConfig;
    private Timer timer = new Timer();
    private ArrayList<Context> contexts = new ArrayList();
    private ClassLoader classloader;
    private String[] classpathEntries;
    private LocalRepository repository;

    public WebAppEngine(File baseDir, String configurationDir, int port, IAppServerConfiguration appServerConfig, ClassLoader classloader, String[] classpathEntries, String localRepositoryPath) {
        this.baseDir = baseDir;
        this.configurationDir = configurationDir;
        this.port = port;
        this.appServerConfig = appServerConfig;
        this.classpathEntries = classpathEntries;
        this.repository = localRepositoryPath != null ? new LocalRepository(new File(localRepositoryPath)) : new LocalRepository();
        System.setProperty("stax.repository", this.repository.getRepositoryPath());
        this.classloader = this.createApplicationClassLoader(appServerConfig, this.repository, classloader);
    }

    @Override
    public Engine createEngine(Embedded container) throws Exception {
        String appBase = new File(this.configurationDir, "webapps").getAbsolutePath();
        Host host = container.createHost("localhost", appBase);
        List<Context> contexts = this.createWebContexts(container);
        for (Context context : contexts) {
            host.addChild((Container)context);
        }
        Engine engine = container.createEngine();
        engine.setName("localEngine");
        engine.addChild((Container)host);
        engine.setDefaultHost(host.getName());
        container.addEngine(engine);
        this.initContainer(container, engine);
        return engine;
    }

    private void initContainer(Embedded container, Engine engine) throws ServletException {
        Connector httpConnector = this.createMainHttpConnector(container);
        container.addConnector(httpConnector);
        RemoteIpValve remoteValve = new RemoteIpValve();
        remoteValve.setRemoteIpHeader("X-Forwarded-For");
        remoteValve.setProtocolHeader("X-Forwarded-Proto");
        engine.getPipeline().addValve((Valve)remoteValve);
        engine.getPipeline().addValve((Valve)new RequestSetupValve(this.appServerConfig));
        if (this.appServerConfig.getServerCallbackUrl() != null) {
            engine.getPipeline().addValve((Valve)new StaxApplicationQueryValve(this.appServerConfig, this.port, this.timer));
        }
        if (this.appServerConfig.isPrivate()) {
            engine.getPipeline().addValve((Valve)new PrivateApplicationValve(this.appServerConfig));
        }
        engine.getPipeline().addValve((Valve)new RequestMonitorValve(this.appServerConfig));
        for (Context context : this.contexts) {
            this.initDataSources(context, this.appServerConfig.getAppConfiguration().getResources());
        }
        if (this.appServerConfig.getAppConfiguration().getRealm() != null) {
            this.initAuthenticationRealm(engine, this.appServerConfig.getAppConfiguration().getRealm());
        }
    }

    private Connector createMainHttpConnector(Embedded container) {
        HttpConfig httpConfig = this.appServerConfig.getHttpConfig();
        String systemConnectorProtocol = System.getProperty("stax.connector.protocol");
        String protocol = httpConfig.getProtocol();
        if (systemConnectorProtocol != null) {
            protocol = systemConnectorProtocol;
        }
        logger.log(Level.INFO, String.format("Initializing http-connector protocol: %s", protocol));
        Connector httpConnector = container.createConnector((InetAddress)null, this.port, protocol);
        this.applyParametersToObject(httpConnector, httpConfig.getParameters(), "http-connector");
        httpConnector.setURIEncoding("UTF-8");
        return httpConnector;
    }

    private void initAuthenticationRealm(Engine engine, RealmConfig realmConfig) {
        String className = realmConfig.getParameter("className");
        if (className == null) {
            className = "org.apache.catalina.realm.JDBCRealm";
        }
        try {
            Realm realm = (Realm)this.classloader.loadClass(className).newInstance();
            this.applyParametersToObject(realm, realmConfig.getParameters(), "realm");
            engine.setRealm(realm);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "failed to initialize realm", e);
        }
    }

    private void applyParametersToObject(Object obj, List<ParamConfig> parameters, String objectName) {
        for (ParamConfig param : parameters) {
            IntrospectionUtils.setProperty((Object)obj, (String)param.getName(), (String)param.getValue());
            logger.log(Level.INFO, String.format("%s - applied %s=%s", objectName, param.getName(), param.getValue()));
        }
    }

    private void initDataSources(Context context, List<ResourceConfig> resources) {
        String sessionDataSource = this.appServerConfig.getAppConfiguration().getSessionDataSource();
        for (ResourceConfig resourceConfig : resources) {
            ContextResource resource = new ContextResource();
            String resourceName = resourceConfig.getName();
            resource.setName(resourceName);
            resource.setType(resourceConfig.getType());
            resource.setAuth(resourceConfig.getAuth());
            resource.setScope("Shareable");
            resource.setProperty("reference.name", (Object)resourceName);
            HashMap<String, String> dsProperties = new HashMap<String, String>();
            for (ParamConfig param : resourceConfig.getParameters()) {
                resource.setProperty(param.getName(), (Object)param.getValue());
                dsProperties.put(param.getName(), param.getValue());
            }
            resource.setProperty("factory", (Object)"com.staxnet.jdbc.StaxDataSourceFactory");
            context.getNamingResources().addResource(resource);
            if (sessionDataSource == null || !sessionDataSource.equals(resourceName)) continue;
            this.CLUSTER_SESSIONS = true;
        }
        if (sessionDataSource != null && !this.CLUSTER_SESSIONS) {
            logger.warning("session datasource [" + sessionDataSource + "]not defined, session clustering is not enabled");
        }
    }

    private List<Context> createWebContexts(Embedded container) {
        for (WebConfig webconfig : this.appServerConfig.getAppConfiguration().getWebConfigs()) {
            String warDir = webconfig.getWebUri();
            if (new File(warDir).exists()) {
                warDir = new File(warDir).getAbsolutePath();
            } else {
                File relDir = new File(this.baseDir, warDir);
                if (!relDir.exists()) {
                    throw new IllegalArgumentException("war directory does not exist: " + relDir.getAbsolutePath());
                }
                warDir = relDir.getAbsolutePath();
            }
            StandardContext context = (StandardContext)container.createContext(webconfig.getContextRoot(), warDir);
            WebappLoader loader = new WebappLoader(this.classloader);
            List<DependencyConfig> dependencies = webconfig.getDependencies();
            for (DependencyConfig dependency : dependencies) {
                ModuleConfig module = new ModuleConfig();
                ModuleParser moduleParser = new ModuleParser();
                File moduleDir = null;
                try {
                    moduleDir = this.repository.getModuleZip(dependency.getOrg(), dependency.getName(), dependency.getRev());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (moduleDir == null || !moduleDir.exists()) {
                    throw new RuntimeException("Missing required module: " + dependency.getOrg() + "/" + dependency.getName() + "-" + dependency.getRev());
                }
                File moduleConfigFile = new File(moduleDir, "META-INF" + File.separator + "stax-module.xml");
                moduleParser.load(module, moduleConfigFile.getAbsolutePath());
                for (String classpathEntry : module.getClasspath()) {
                    File cpEntry = new File(moduleDir, classpathEntry.replace('/', File.separatorChar));
                    if (cpEntry.exists()) {
                        logger.log(Level.FINE, String.format("adding module classpath resource [%s:%s:%s", dependency.getOrg(), dependency.getName(), classpathEntry));
                        try {
                            loader.addRepository(cpEntry.toURL().toString());
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    throw new RuntimeException("Missing required module resource: " + dependency.getOrg() + ":" + dependency.getName() + ":" + classpathEntry);
                }
            }
            logger.log(Level.INFO, String.format("loading app [%s] from %s", webconfig.getContextRoot(), warDir));
            for (String classpathEntry : this.classpathEntries) {
                loader.addRepository(classpathEntry);
            }
            String javaHome = System.getenv("JAVA_HOME");
            if (javaHome != null) {
                File toolsJar = new File(javaHome, "lib" + File.separator + "tools.jar");
                if (toolsJar.exists()) {
                    try {
                        loader.addRepository(toolsJar.toURL().toString());
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                } else {
                    logger.log(Level.WARNING, "tools.jar is not in the classpath");
                }
            } else {
                logger.log(Level.WARNING, "tools.jar is not in the classpath");
            }
            context.setLoader((Loader)loader);
            boolean reloadEnabled = this.appServerConfig.isReloadEnabled();
            logger.log(Level.INFO, "application reloading is " + (reloadEnabled ? "enabled" : "disabled"));
            context.setReloadable(reloadEnabled);
            context.setCrossContext(true);
            context.setDistributable(true);
            context.addApplicationListener("net.stax.appserver.webapp.FirstServletContextListener");
            this.contexts.add((Context)context);
            String logLicense = this.appServerConfig.getServerParams().getParamValue("stax.logging.license", null);
            String logSource = this.appServerConfig.getServerParams().getParamValue("stax.logging.source", null);
            String logBaseUrl = this.appServerConfig.getServerParams().getParamValue("stax.logging.baseUrl", null);
            if (logLicense != null && logSource != null) {
                context.addContainerListener((ContainerListener)new LoggingContext(logBaseUrl, logLicense, logSource));
            }
            context.addContainerListener((ContainerListener)new ContextInitHelper((Context)context, this.appServerConfig, webconfig));
            this.registerContextListener("com.staxnet.appserver.jmx.AppManagementContext", context);
            StandardContext targetContext = context;
            context.addLifecycleListener(new LifecycleListener((Context)targetContext, webconfig){
                final /* synthetic */ Context val$targetContext;
                final /* synthetic */ WebConfig val$webconfig;
                {
                    this.val$targetContext = context;
                    this.val$webconfig = webConfig;
                }

                public void lifecycleEvent(LifecycleEvent evt) {
                    if (evt.getType().equals("start")) {
                        if (WebAppEngine.this.CLUSTER_SESSIONS) {
                            logger.info("session clustering enabled using datasource: " + WebAppEngine.this.appServerConfig.getAppConfiguration().getSessionDataSource());
                            PersistentManager managerBase = new PersistentManager();
                            managerBase.setSaveOnRestart(true);
                            managerBase.setMaxActiveSessions(-1);
                            managerBase.setMinIdleSwap(-1);
                            managerBase.setMaxIdleSwap(-1);
                            managerBase.setMaxIdleBackup(-1);
                            managerBase.setDistributable(true);
                            StaxSessionStore jdbcStore = new StaxSessionStore();
                            jdbcStore.setDataSourceName(WebAppEngine.this.appServerConfig.getAppConfiguration().getSessionDataSource());
                            jdbcStore.setSessionTable("stax_sessions");
                            if (WebAppEngine.this.appServerConfig.getAppConfiguration().getApplicationId() != null) {
                                jdbcStore.setName(WebAppEngine.this.appServerConfig.getAppConfiguration().getApplicationId());
                            }
                            managerBase.setStore((Store)jdbcStore);
                            this.val$targetContext.setManager((Manager)managerBase);
                        }
                        for (ContextParamConfig param : this.val$webconfig.getParameters()) {
                            if (param.getName() == null) {
                                logger.warning("Null context-param name detected");
                                continue;
                            }
                            if (param.getValue() == null) {
                                logger.warning("Null context-param value detected and ignored. {param-name: " + param.getName() + "}");
                                continue;
                            }
                            this.val$targetContext.removeParameter(param.getName());
                            this.val$targetContext.addParameter(param.getName(), param.getValue());
                        }
                    }
                }
            });
        }
        return this.contexts;
    }

    private void registerContextListener(String className, StandardContext context) {
        try {
            Object listener = this.classloader.loadClass(className).newInstance();
            if (listener instanceof ContainerListener) {
                context.addContainerListener((ContainerListener)listener);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to load context listener: " + className, e);
        }
    }

    protected ClassLoader createApplicationClassLoader(IAppServerConfiguration config, LocalRepository repository, ClassLoader parent) {
        ArrayList<URL> urls = new ArrayList<URL>();
        HashMap<URL, URL> urlTable = new HashMap<URL, URL>();
        for (DependencyConfig dependency : config.getDependencies()) {
            String dependencyId = dependency.getOrg() + "/" + dependency.getName() + "-" + dependency.getRev();
            try {
                ModuleConfig module = new ModuleConfig();
                ModuleParser moduleParser = new ModuleParser();
                File moduleDir = null;
                try {
                    moduleDir = repository.getModuleZip(dependency.getOrg(), dependency.getName(), dependency.getRev());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (moduleDir == null || !moduleDir.exists()) continue;
                File moduleConfigFile = new File(moduleDir, "META-INF" + File.separator + "stax-module.xml");
                moduleParser.load(module, moduleConfigFile.getAbsolutePath());
                for (String classpathEntry : module.getClasspath()) {
                    File cpEntry = new File(moduleDir, classpathEntry.replace('/', File.separatorChar));
                    if (cpEntry.exists()) {
                        logger.log(Level.FINE, String.format("adding module classpath resource [%s:%s:%s", dependency.getOrg(), dependency.getName(), classpathEntry));
                        try {
                            URL cpEntryURL = cpEntry.toURI().toURL();
                            if (urlTable.containsKey(cpEntryURL)) continue;
                            urls.add(cpEntryURL);
                            urlTable.put(cpEntryURL, cpEntryURL);
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    logger.warning("Missing required module resource: " + dependencyId + ":" + classpathEntry);
                }
            }
            catch (Exception e) {
                logger.warning("Failed to load dependency: " + dependencyId);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[0]), parent);
    }

    class ContextInitHelper
    implements ContainerListener {
        WebConfig webconfig;
        Context context;
        IAppServerConfiguration config;
        boolean inited = false;

        ContextInitHelper(Context context, IAppServerConfiguration config, WebConfig webconfig) {
            this.context = context;
            this.config = config;
            this.webconfig = webconfig;
        }

        public void containerEvent(ContainerEvent evt) {
            if (!this.inited) {
                this.inited = true;
                if (WebAppEngine.this.CLUSTER_SESSIONS) {
                    PersistentValve pValve = new PersistentValve();
                    this.context.getPipeline().addValve((Valve)pValve);
                }
                if (this.config.getColdFusionLicense() != null) {
                    this.initCFLicense(this.context.getLoader(), this.config.getColdFusionLicense());
                }
            }
        }

        private void initCFLicense(final Loader loader, final String licenseSN) {
            Thread th = new Thread(new Runnable(){

                @Override
                public void run() {
                    Object licenseService = null;
                    try {
                        for (int i = 0; i < 30; ++i) {
                            if (loader.getClassLoader() != null) {
                                Class<?> cls = loader.getClassLoader().loadClass("coldfusion.server.ServiceFactory");
                                Method m = cls.getMethod("getLicenseService", new Class[0]);
                                for (int j = 0; j < 30 && licenseService == null; ++j) {
                                    licenseService = m.invoke(null, new Object[0]);
                                    if (licenseService != null) {
                                        Method setter = licenseService.getClass().getMethod("setLicenseKey", String.class);
                                        setter.invoke(licenseService, licenseSN);
                                    }
                                    logger.log(Level.FINE, "waiting for CF License Service to start...");
                                    Thread.sleep(1000L);
                                }
                                if (licenseService == null) {
                                    logger.log(Level.WARNING, "Coldfusion license was not set [reason: license service not available]");
                                }
                                return;
                            }
                            Thread.sleep(1000L);
                        }
                        logger.log(Level.WARNING, "application classloader never became available");
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "error initializing CF license");
                        e.printStackTrace();
                    }
                }
            });
            th.start();
        }
    }
}

