/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appgen;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.Main;

public class AppGenerator {
    private File antFile;
    private Properties properties;
    private boolean verbose = false;
    private String target = null;

    public AppGenerator(File antFile) {
        this(antFile, new Properties());
    }

    public AppGenerator(File antFile, Properties props) {
        this.antFile = antFile;
        this.properties = props;
        if (!antFile.exists()) {
            throw new IllegalArgumentException("No such ant script: " + antFile.getAbsolutePath());
        }
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void generate(File outputDir) {
        AntMain m = new AntMain();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        props.setProperty("outputdir", outputDir.getAbsolutePath());
        props.setProperty("basedir", this.antFile.getParent());
        ArrayList<String> args = new ArrayList<String>();
        if (this.verbose) {
            args.add("-v");
        }
        args.add("-f");
        args.add(this.antFile.getAbsolutePath());
        if (this.target != null) {
            args.add(this.target);
        }
        m.startAnt(args.toArray(new String[0]), props, this.getClass().getClassLoader());
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    class AntMain
    extends Main {
        int exitCode = 0;

        AntMain() {
        }

        protected void exit(int exitCode) {
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

