/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appgen;

import java.io.File;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class Group {
    private Class lexerClass = DefaultTemplateLexer.class;
    private String dir;
    private String file;
    private Group subgroup;
    private Project project;

    public Group(Project p) {
        this.project = p;
    }

    public void setLexer(String lexer) throws BuildException {
        if (lexer.equals("default")) {
            this.lexerClass = DefaultTemplateLexer.class;
        } else if (lexer.equals("angle-bracket")) {
            this.lexerClass = AngleBracketTemplateLexer.class;
        } else {
            throw new BuildException("Invalid lexer value: " + lexer + ". Expected default or angle-bracket");
        }
    }

    public void setDir(String dir) {
        this.dir = dir;
        File f = this.project.resolveFile(dir);
        if (!f.exists()) {
            this.project.log("missing template group dir: " + f.getAbsolutePath());
        }
    }

    public String getDir() {
        return this.dir;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
        File f = this.project.resolveFile(file);
        if (!f.exists()) {
            this.project.log("missing template group file: " + f.getAbsolutePath());
        }
    }

    public Class getLexerClass() {
        return this.lexerClass;
    }

    public Group getSubgroup() {
        return this.subgroup;
    }

    public void setSubgroup(Group subgroup) {
        this.subgroup = subgroup;
    }

    public Group createGroup() {
        if (this.subgroup != null) {
            throw new BuildException("Sibling groups are not allowed");
        }
        this.subgroup = new Group(this.project);
        return this.subgroup;
    }
}

