/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appgen;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.stax.appgen.Group;
import net.stax.appgen.Property;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class Template {
    private Class lexerClass;
    private Group group;
    private Project project;
    private List<Property> proplist = new ArrayList<Property>();
    private String refid;

    public Template(Project project) {
        this.project = project;
    }

    public Property createProperty() {
        Property p = new Property();
        this.proplist.add(p);
        return p;
    }

    public String getRefid() {
        return this.refid;
    }

    public void setRefid(String refid) {
        this.refid = refid;
    }

    public void setLexer(String lexer) {
        if (lexer.equals("default")) {
            this.lexerClass = DefaultTemplateLexer.class;
        } else if (lexer.equals("angle-bracket")) {
            this.lexerClass = AngleBracketTemplateLexer.class;
        } else {
            throw new BuildException("Invalid lexer value: " + lexer + ". Expected default or angle-bracket");
        }
    }

    public Group createGroup() {
        if (this.group != null) {
            throw new BuildException("Sibling groups are not allowed");
        }
        this.group = new Group(this.project);
        return this.group;
    }

    public StringTemplate createTemplate(String text) {
        StringTemplate template = new StringTemplate(text, this.lexerClass);
        if (this.group != null) {
            template.setGroup(this.createTemplateGroup(this.group));
        }
        for (Property property : this.proplist) {
            template.setAttribute(property.getName(), (Object)property.getValue());
        }
        return template;
    }

    private StringTemplateGroup createTemplateGroup(Group g) {
        try {
            StringTemplateGroup tg;
            if (g.getDir() != null) {
                String groupDir = this.project.resolveFile(g.getDir()).getAbsolutePath();
                tg = new StringTemplateGroup("group", groupDir, g.getLexerClass());
            } else if (g.getFile() != null) {
                File groupFile = this.project.resolveFile(g.getFile());
                String templateGroupContent = this.readAll(new FileReader(groupFile), true);
                tg = new StringTemplateGroup((Reader)new StringReader(templateGroupContent), g.getLexerClass());
            } else {
                tg = new StringTemplateGroup("group", g.getLexerClass());
            }
            if (g.getSubgroup() != null) {
                StringTemplateGroup subgroup = this.createTemplateGroup(g.getSubgroup());
                subgroup.setSuperGroup(tg);
                tg = subgroup;
            }
            return tg;
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAll(Reader r, boolean close) throws IOException {
        try {
            StringBuffer sb = new StringBuffer();
            char[] buf = new char[1024];
            int numRead = r.read(buf);
            while (numRead != -1) {
                sb.append(buf, 0, numRead);
                numRead = r.read(buf);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (close) {
                r.close();
            }
        }
    }
}

