/*
 * Decompiled with CFR 0.152.
 */
package net.stax.appserver.bootstrap;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class Bootstrap {
    private static final String appserverMainClassName = "com.staxnet.appserver.SnazAppServer";
    private static final String appserverJarName = "appserver.jar";

    public static void main(String[] args) throws Exception {
        URLClassLoader loader = Bootstrap.createAppServerClassLoader();
        Bootstrap.invokeAppServerMain(args, loader);
    }

    private static void invokeAppServerMain(String[] args, URLClassLoader loader) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> cls = loader.loadClass(appserverMainClassName);
        Method m = cls.getMethod("main", args.getClass());
        m.invoke(null, new Object[]{args});
    }

    private static URLClassLoader createAppServerClassLoader() throws Exception {
        File myjar = Bootstrap.findMyJarFile();
        File appserverJar = new File(myjar.getParentFile(), appserverJarName);
        if (!appserverJar.exists()) {
            throw new IllegalStateException("appserver jar file is missing: " + appserverJar);
        }
        URLClassLoader loader = new URLClassLoader(new URL[]{appserverJar.toURI().toURL()});
        return loader;
    }

    private static File findMyJarFile() throws Exception {
        String resourcePath = Bootstrap.class.getName().replace(".", "/") + ".class";
        URL url = Bootstrap.class.getClassLoader().getResource(resourcePath);
        if (url == null) {
            throw new IllegalStateException("I can't locate my jar file!");
        }
        String filePart = url.getFile();
        String[] parts = filePart.split("!");
        String fileUrl = parts[0];
        String filePath = new URL(fileUrl).getFile();
        File myJarFile = new File(filePath);
        if (!myJarFile.exists()) {
            throw new IllegalStateException("my jar path was miscalculated (jvm difference??): " + url);
        }
        return myJarFile;
    }
}

