/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
    private static int BUFFER = 2048;

    public static final void addDirectoryToZip(File directory, File base, String dirPrefix, ZipOutputStream zos) throws IOException {
        if (base == null) {
            base = directory;
        }
        if (dirPrefix == null) {
            dirPrefix = "";
        }
        if (!base.equals(directory)) {
            String dirEntryPath = dirPrefix + directory.getPath().substring(base.getPath().length() + 1).replace('\\', '/');
            ZipEntry dirEntry = new ZipEntry(dirEntryPath.endsWith("/") ? dirEntryPath : dirEntryPath + "/");
            zos.putNextEntry(dirEntry);
        }
        File[] files = directory.listFiles();
        byte[] buffer = new byte[8192];
        int read = 0;
        int n = files.length;
        for (int i = 0; i < n; ++i) {
            if (files[i].isDirectory()) {
                ZipHelper.addDirectoryToZip(files[i], base, dirPrefix, zos);
                continue;
            }
            FileInputStream in = new FileInputStream(files[i]);
            ZipEntry entry = new ZipEntry(dirPrefix + files[i].getPath().substring(base.getPath().length() + 1).replace('\\', '/'));
            entry.setTime(files[i].lastModified());
            zos.putNextEntry(entry);
            while (-1 != (read = in.read(buffer))) {
                zos.write(buffer, 0, read);
            }
            in.close();
        }
    }

    public static File unzipEntryToFolder(ZipEntry entry, InputStream zis, File destFolder) throws IOException {
        int count;
        if (entry.isDirectory()) {
            File destFile = new File(destFolder, entry.getName());
            destFile.mkdirs();
            return destFile;
        }
        byte[] data = new byte[BUFFER];
        File destFile = new File(destFolder, entry.getName());
        File parentFolder = destFile.getParentFile();
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        BufferedOutputStream dest = new BufferedOutputStream(fos, BUFFER);
        while ((count = zis.read(data, 0, BUFFER)) != -1) {
            dest.write(data, 0, count);
        }
        dest.flush();
        dest.close();
        return destFile;
    }
}

