/*
 * Decompiled with CFR 0.152.
 */
package net.stax.api;

import com.cloudbees.upload.ArchiveUtils;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.stax.api.ApplicationCheckSumsResponse;
import net.stax.api.ApplicationDeleteResponse;
import net.stax.api.ApplicationDeployArchiveResponse;
import net.stax.api.ApplicationDeployResponse;
import net.stax.api.ApplicationGetSourceUrlResponse;
import net.stax.api.ApplicationInfo;
import net.stax.api.ApplicationInfoResponse;
import net.stax.api.ApplicationInstallResponse;
import net.stax.api.ApplicationListResponse;
import net.stax.api.ApplicationRestartResponse;
import net.stax.api.ApplicationSetMetaResponse;
import net.stax.api.ApplicationStatusResponse;
import net.stax.api.DatabaseCreateResponse;
import net.stax.api.DatabaseDeleteResponse;
import net.stax.api.DatabaseInfo;
import net.stax.api.DatabaseInfoResponse;
import net.stax.api.DatabaseListResponse;
import net.stax.api.ErrorResponse;
import net.stax.api.SayHelloResponse;
import net.stax.api.StaxClientBase;
import net.stax.api.StaxClientException;
import net.stax.api.UploadProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxClient
extends StaxClientBase {
    static Logger logger = Logger.getLogger(StaxClient.class.getSimpleName());

    public StaxClient(String server, String apikey, String secret, String format, String version) {
        super(server, apikey, StaxClient.encodePassword(secret, version), format, version);
    }

    public SayHelloResponse sayHello(String message) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("message", message);
        String url = this.getRequestURL("say.hello", params);
        System.out.println("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        SayHelloResponse helloResponse = (SayHelloResponse)this.readResponse(response);
        return helloResponse;
    }

    public ApplicationGetSourceUrlResponse applicationGetSourceUrl(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.getSourceUrl", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        ApplicationGetSourceUrlResponse apiResponse = (ApplicationGetSourceUrlResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationDeleteResponse applicationDelete(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.delete", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        ApplicationDeleteResponse apiResponse = (ApplicationDeleteResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationRestartResponse applicationRestart(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.restart", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        ApplicationRestartResponse apiResponse = (ApplicationRestartResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationStatusResponse applicationStart(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.start", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        ApplicationStatusResponse apiResponse = (ApplicationStatusResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationStatusResponse applicationStop(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.stop", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        ApplicationStatusResponse apiResponse = (ApplicationStatusResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationListResponse applicationList() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        String url = this.getRequestURL("application.list", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        ApplicationListResponse apiResponse = (ApplicationListResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationInfo applicationInfo(String appId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.info", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        ApplicationInfoResponse apiResponse = (ApplicationInfoResponse)this.readResponse(response);
        return apiResponse.getApplicationInfo();
    }

    public ApplicationSetMetaResponse applicationSetMeta(String appId, Map<String, String> metaAttrs) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(metaAttrs);
        params.put("app_id", appId);
        String url = this.getRequestURL("application.setMeta", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        ApplicationSetMetaResponse apiResponse = (ApplicationSetMetaResponse)this.readResponse(response);
        return apiResponse;
    }

    public ApplicationDeployArchiveResponse applicationDeployEar(String appId, String environment, String description, String earFile, String srcFile, UploadProgress progress) throws Exception {
        String archiveType = "ear";
        return this.applicationDeployArchive(appId, environment, description, earFile, srcFile, archiveType, false, progress);
    }

    public ApplicationDeployArchiveResponse applicationDeployWar(String appId, String environment, String description, String earFile, String srcFile, UploadProgress progress) throws Exception {
        return this.applicationDeployWar(appId, environment, description, earFile, srcFile, true, progress);
    }

    public ApplicationDeployArchiveResponse applicationDeployWar(String appId, String environment, String description, String earFile, String srcFile, boolean deltaDeploy, UploadProgress progress) throws Exception {
        String archiveType = "war";
        return this.applicationDeployArchive(appId, environment, description, earFile, srcFile, archiveType, deltaDeploy, progress);
    }

    public ApplicationDeployArchiveResponse applicationDeployArchive(String appId, String environment, String description, String earFile, String srcFile, String archiveType, UploadProgress progress) throws Exception {
        return this.applicationDeployArchive(appId, environment, description, earFile, srcFile, archiveType, false, progress);
    }

    public ApplicationDeployArchiveResponse applicationDeployArchive(String appId, String environment, String description, String earFile, String srcFile, String archiveType, boolean deltaDeploy, UploadProgress progress) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, File> fileParams = new HashMap<String, File>();
        params.put("app_id", appId);
        File archiveFile = new File(earFile);
        boolean deployDelta = false;
        if (deltaDeploy && archiveType.equals("war")) {
            logger.info("Get existing checksums");
            ApplicationCheckSumsResponse applicationCheckSumsResponse = this.applicationCheckSums(appId, false);
            if (logger.isLoggable(Level.FINER)) {
                for (Map.Entry<String, Long> entry : applicationCheckSumsResponse.getCheckSums().entrySet()) {
                    logger.finer("Entry: " + entry.getKey() + " CRC: " + entry.getValue());
                }
            }
            if (applicationCheckSumsResponse.getCheckSums().size() == 0) {
                logger.info("No existing checksums, upload full archive");
            } else {
                logger.info("Creating Delta archive for: " + archiveFile);
                archiveFile = ArchiveUtils.createDeltaWarFile(applicationCheckSumsResponse.getCheckSums(), archiveFile, archiveFile.getParent());
                deployDelta = true;
                logger.info("Uploading delta archive: " + archiveFile);
            }
        }
        File archiveFileSrc = srcFile != null ? new File(srcFile) : null;
        long uploadSize = archiveFile.length();
        if (archiveFileSrc != null) {
            uploadSize += archiveFileSrc.length();
        }
        fileParams.put("archive", archiveFile);
        params.put("archive_type", archiveType);
        if (environment != null) {
            params.put("environment", environment);
        }
        if (description != null) {
            params.put("description", description);
        }
        if (archiveFileSrc != null) {
            fileParams.put("src", archiveFileSrc);
        }
        long expireTime = System.currentTimeMillis() + 14400000L;
        params.put("expires", new Long(expireTime / 1000L).toString());
        String url = this.getApiUrl("application.deployArchive").toString();
        params.put("action", "application.deployArchive");
        this.trace("API call: " + url);
        String response = this.executeUpload(url, params, fileParams, progress);
        try {
            ApplicationDeployArchiveResponse apiResponse = (ApplicationDeployArchiveResponse)this.readResponse(response);
            if (deployDelta) {
                archiveFile.delete();
            }
            return apiResponse;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Invalid application deployment response: " + appId, e);
            logger.log(Level.FINE, "Deploy response trace: " + response);
            throw e;
        }
    }

    public ApplicationCheckSumsResponse applicationCheckSums(String appId) throws Exception {
        return this.applicationCheckSums(appId, true);
    }

    public ApplicationCheckSumsResponse applicationCheckSums(String appId, boolean traceResponse) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        String url = this.getRequestURL("application.checkSums", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        if (traceResponse) {
            this.traceResponse(response);
        }
        ApplicationCheckSumsResponse apiResponse = (ApplicationCheckSumsResponse)this.readResponse(response);
        return apiResponse;
    }

    public DatabaseCreateResponse databaseCreate(String domain, String dbId, String username, String password) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("database_id", dbId);
        params.put("database_username", username);
        params.put("database_password", password);
        params.put("domain", domain);
        String url = this.getRequestURL("database.create", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        DatabaseCreateResponse apiResponse = (DatabaseCreateResponse)this.readResponse(response);
        return apiResponse;
    }

    public DatabaseDeleteResponse databaseDelete(String dbId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("database_id", dbId);
        String url = this.getRequestURL("database.delete", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        DatabaseDeleteResponse apiResponse = (DatabaseDeleteResponse)this.readResponse(response);
        return apiResponse;
    }

    public DatabaseInfo databaseInfo(String dbId, boolean fetchPassword) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("database_id", dbId);
        params.put("fetch_password", Boolean.valueOf(fetchPassword).toString());
        String url = this.getRequestURL("database.info", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        DatabaseInfoResponse apiResponse = (DatabaseInfoResponse)this.readResponse(response);
        return apiResponse.getDatabaseInfo();
    }

    public DatabaseListResponse databaseList() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        String url = this.getRequestURL("database.list", params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        DatabaseListResponse apiResponse = (DatabaseListResponse)this.readResponse(response);
        return apiResponse;
    }

    public void tailLog(String appId, String logName, OutputStream out) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", appId);
        params.put("log_name", logName);
        String url = this.getRequestURL("tail", params, false);
        this.trace("API call: " + url);
        StaxClientBase.CometConnection cometConnection = this.executeCometRequest(url);
        InputStream input = cometConnection.getInput();
        byte[] bytes = new byte[1024];
        int numRead = input.read(bytes);
        while (numRead != -1) {
            out.write(bytes, 0, numRead);
            numRead = input.read(bytes);
        }
    }

    public String call(String action, Map<String, String> params) throws Exception {
        String url = this.getRequestURL(action, params);
        this.trace("API call: " + url);
        String response = this.executeRequest(url);
        this.traceResponse(response);
        return response;
    }

    protected Object readResponse(String response) throws Exception {
        XStream xstream = null;
        if (this.format.equals("json")) {
            xstream = new XStream((HierarchicalStreamDriver)new JettisonMappedXmlDriver());
        } else if (this.format.equals("xml")) {
            xstream = new XStream();
        } else {
            throw new Exception("Unknown format: " + this.format);
        }
        xstream.processAnnotations(SayHelloResponse.class);
        xstream.processAnnotations(ApplicationGetSourceUrlResponse.class);
        xstream.processAnnotations(ApplicationDeleteResponse.class);
        xstream.processAnnotations(ApplicationDeployResponse.class);
        xstream.processAnnotations(ApplicationDeployArchiveResponse.class);
        xstream.processAnnotations(ApplicationInstallResponse.class);
        xstream.processAnnotations(ApplicationInfo.class);
        xstream.processAnnotations(ApplicationInfoResponse.class);
        xstream.processAnnotations(ApplicationListResponse.class);
        xstream.processAnnotations(ApplicationRestartResponse.class);
        xstream.processAnnotations(ApplicationStatusResponse.class);
        xstream.processAnnotations(ApplicationSetMetaResponse.class);
        xstream.processAnnotations(ApplicationCheckSumsResponse.class);
        xstream.processAnnotations(DatabaseCreateResponse.class);
        xstream.processAnnotations(DatabaseDeleteResponse.class);
        xstream.processAnnotations(DatabaseInfo.class);
        xstream.processAnnotations(DatabaseInfoResponse.class);
        xstream.processAnnotations(DatabaseListResponse.class);
        xstream.processAnnotations(ErrorResponse.class);
        Object obj = xstream.fromXML(response);
        if (obj instanceof ErrorResponse) {
            throw new StaxClientException((ErrorResponse)obj);
        }
        return obj;
    }

    public static String encodePassword(String password, String version) {
        if (version.equals("0.1")) {
            try {
                MessageDigest sha = MessageDigest.getInstance("SHA");
                byte[] shaBytes = sha.digest(password.getBytes("UTF8"));
                StringBuffer hex = new StringBuffer();
                for (int i = 0; i < shaBytes.length; ++i) {
                    hex.append(Integer.toHexString(shaBytes[i] & 0xFF | 0x100).substring(1, 3));
                }
                return hex.toString();
            }
            catch (NoSuchAlgorithmException e) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return null;
        }
        return password;
    }

    private void trace(String message) {
        System.out.println(message);
    }

    private void traceResponse(String message) {
        System.out.println("xml response: " + message);
    }

    public void mainCall(String[] args) throws Exception {
        String action;
        HashMap<String, String> params = new HashMap<String, String>();
        int argIndex = 0;
        if (argIndex < args.length) {
            action = args[argIndex++];
            while (argIndex < args.length) {
                String arg = args[argIndex];
                String[] pair = arg.split("=", 2);
                if (pair.length < 2) {
                    throw new UsageError("Marlformed call parameter pair: " + arg);
                }
                params.put(pair[0], pair[1]);
                ++argIndex;
            }
        } else {
            throw new UsageError("Missing required action argument");
        }
        String response = this.call(action, params);
        System.out.println(response);
    }

    public void main(String[] args) throws Exception {
        String arg;
        int argIndex;
        HashMap<String, String> options = new HashMap<String, String>();
        for (argIndex = 0; argIndex < args.length && (arg = args[argIndex]).startsWith("-"); ++argIndex) {
            if (arg.equals("--call") || arg.equals("-c")) {
                options.put("operation", arg);
                continue;
            }
            if (arg.equals("--username") || arg.equals("-u")) {
                options.put("username", arg);
                continue;
            }
            if (arg.equals("--password") || arg.equals("-p")) {
                options.put("password", arg);
                continue;
            }
            if (arg.equals("--url") || arg.equals("-u")) {
                options.put("url", arg);
                continue;
            }
            throw new UsageError("Unsupported option: " + arg);
        }
        String operation = StaxClient.getRequiredOption("operation", options);
        StaxClient client = new StaxClient(StaxClient.getRequiredOption("url", options), StaxClient.getRequiredOption("username", options), StaxClient.getRequiredOption("password", options), "0.1", "1.0");
        if (operation.equals("call")) {
            String[] subArgs = new String[args.length - argIndex];
            for (int i = 0; i < subArgs.length; ++i) {
                subArgs[i] = args[argIndex++];
            }
            client.main(subArgs);
        }
    }

    private static String getRequiredOption(String optionName, Map<String, String> options) throws UsageError {
        if (options.containsKey(optionName)) {
            return options.get(optionName);
        }
        throw new UsageError("Missing required flag: --" + optionName);
    }

    public static class UsageError
    extends Exception {
        UsageError(String reason) {
            super(reason);
        }
    }
}

