/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.utils;

import com.cloudbees.api.ApplicationConfiguration;
import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AppConfigParser {
    public void load(ApplicationConfiguration applicationConfiguration, Document doc, String[] environments, String[] implicitEnvironments) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            Element e = doc.getDocumentElement();
            this.applyToAppConfig(applicationConfiguration, xpath, e);
            applicationConfiguration.setDefaultEnvironment(e.getAttribute("default"));
            environments = environments == null || environments.length == 0 ? AppConfigParser.getEnvironmentList(applicationConfiguration.getDefaultEnvironment(), implicitEnvironments) : AppConfigParser.getEnvironmentList(this.join(environments, ","), implicitEnvironments);
            NodeList nodes = (NodeList)xpath.evaluate("environment", e, XPathConstants.NODESET);
            HashMap<String, Node> envNodes = new HashMap<String, Node>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node n = nodes.item(i);
                String envName = this.getAttribute(n, "name", null);
                if (envName == null) {
                    throw new IllegalArgumentException("missing required attribute (name) on environment element");
                }
                envNodes.put(envName, n);
            }
            if (environments != null) {
                for (String env : environments) {
                    Node n = (Node)envNodes.get(env);
                    if (n == null) continue;
                    this.applyToAppConfig(applicationConfiguration, xpath, n);
                    applicationConfiguration.getAppliedEnvironments().add(env);
                }
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    private void applyToAppConfig(ApplicationConfiguration applicationConfiguration, XPath xpath, Node e) throws XPathExpressionException {
        String appId = this.getNodeValue(e, xpath, "appid", true);
        if (appId != null) {
            applicationConfiguration.setApplicationId(appId);
        }
    }

    private String getAttribute(Node node, String attr, String defaultValue) {
        Node attrNode = node.getAttributes().getNamedItem(attr);
        if (attrNode == null) {
            return defaultValue;
        }
        return attrNode.getNodeValue();
    }

    private String getNodeValue(Node node, XPath xpath, String expression, boolean trim) throws XPathExpressionException {
        Node n = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
        if (n == null) {
            return null;
        }
        String nodeValue = xpath.evaluate("text()", n);
        return nodeValue.trim();
    }

    public static String[] getEnvironmentList(String environments, String ... prependEnvs) {
        int i;
        if (environments == null && prependEnvs.length == 0) {
            return new String[0];
        }
        if (environments == null) {
            environments = "";
        }
        String[] envSplit = environments.split(",");
        String[] envList = new String[envSplit.length + prependEnvs.length];
        for (i = 0; i < prependEnvs.length; ++i) {
            envList[i] = prependEnvs[i];
        }
        for (i = 0; i < envSplit.length; ++i) {
            envList[prependEnvs.length + i] = envSplit[i].trim();
        }
        return envList;
    }

    public String join(String[] array, String delim) {
        String str = "";
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                str = str + delim;
            }
            str = str + array[i];
        }
        return str;
    }
}

