/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.ser;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.cloudfoundry.org.codehaus.jackson.map.AnnotationIntrospector;
import org.cloudfoundry.org.codehaus.jackson.map.JsonSerializer;
import org.cloudfoundry.org.codehaus.jackson.map.SerializationConfig;
import org.cloudfoundry.org.codehaus.jackson.map.annotate.JsonSerialize;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.Annotated;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotatedField;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.cloudfoundry.org.codehaus.jackson.map.ser.BeanPropertyWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBuilder {
    final SerializationConfig _config;
    final BasicBeanDescription _beanDesc;
    final JsonSerialize.Inclusion _outputProps;
    final AnnotationIntrospector _annotationIntrospector;
    protected Object _defaultBean;

    public PropertyBuilder(SerializationConfig config, BasicBeanDescription beanDesc) {
        this._config = config;
        this._beanDesc = beanDesc;
        this._outputProps = beanDesc.findSerializationInclusion(config.getSerializationInclusion());
        this._annotationIntrospector = this._config.getAnnotationIntrospector();
    }

    public BeanPropertyWriter buildProperty(String name, JsonSerializer<Object> ser, AnnotatedMethod am, boolean defaultUseStaticTyping) {
        return this._buildProperty(name, ser, defaultUseStaticTyping, am, am.getAnnotated(), null);
    }

    public BeanPropertyWriter buildProperty(String name, JsonSerializer<Object> ser, AnnotatedField af, boolean defaultUseStaticTyping) {
        return this._buildProperty(name, ser, defaultUseStaticTyping, af, null, af.getAnnotated());
    }

    protected BeanPropertyWriter _buildProperty(String name, JsonSerializer<Object> ser, boolean defaultUseStaticTyping, Annotated a, Method m, Field f) {
        Class<?> serializationType = this.findSerializationType(a, defaultUseStaticTyping);
        Object suppValue = null;
        boolean suppressNulls = false;
        JsonSerialize.Inclusion methodProps = this._annotationIntrospector.findSerializationInclusion(a, this._outputProps);
        if (methodProps != null) {
            switch (methodProps) {
                case NON_DEFAULT: {
                    suppValue = this.getDefaultValue(name, m, f);
                    if (suppValue != null) break;
                    suppressNulls = true;
                    break;
                }
                case NON_NULL: {
                    suppressNulls = true;
                }
            }
        }
        return new BeanPropertyWriter(name, ser, serializationType, m, f, suppressNulls, suppValue);
    }

    protected Class<?> findSerializationType(Annotated a, boolean useStaticTyping) {
        Class<?> serializationType = this._annotationIntrospector.findSerializationType(a);
        if (serializationType != null) {
            Class<?> type = a.getType();
            if (!serializationType.isAssignableFrom(type)) {
                throw new IllegalArgumentException("Illegal concrete-type annotation for method '" + a.getName() + "': class " + serializationType.getName() + " not a super-type of (declared) class " + type.getName());
            }
            return serializationType;
        }
        JsonSerialize.Typing typing = this._annotationIntrospector.findSerializationTyping(a);
        if (typing != null) {
            boolean bl = useStaticTyping = typing == JsonSerialize.Typing.STATIC;
        }
        if (useStaticTyping) {
            return a.getType();
        }
        return null;
    }

    protected Object getDefaultBean() {
        if (this._defaultBean == null) {
            this._defaultBean = this._beanDesc.instantiateBean(this._config.isEnabled(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS));
            if (this._defaultBean == null) {
                AnnotatedElement cls = this._beanDesc.getClassInfo().getAnnotated();
                throw new IllegalArgumentException("Class " + ((Class)cls).getName() + " has no default constructor; can not instantiate default bean value to support 'properties=JsonSerialize.Inclusion.NON_DEFAULT' annotation");
            }
        }
        return this._defaultBean;
    }

    protected Object getDefaultValue(String name, Method m, Field f) {
        Object defaultBean = this.getDefaultBean();
        try {
            if (m != null) {
                return m.invoke(defaultBean, new Object[0]);
            }
            return f.get(defaultBean);
        }
        catch (Exception e) {
            return this._throwWrapped(e, name, defaultBean);
        }
    }

    protected Object _throwWrapped(Exception e, String propName, Object defaultBean) {
        Throwable t = e;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new IllegalArgumentException("Failed to get property '" + propName + "' of default " + defaultBean.getClass().getName() + " instance");
    }
}

