/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.env;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.springframework.beans.factory.FactoryBean;

public class CloudEnvironmentPropertiesFactoryBean
implements FactoryBean<Properties> {
    private Properties properties;
    private CloudEnvironment cloudEnv;

    public void setCloudEnv(CloudEnvironment cloudEnv) {
        this.cloudEnv = cloudEnv;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<Properties> getObjectType() {
        return Properties.class;
    }

    public Properties getObject() throws Exception {
        if (this.properties == null) {
            this.properties = this.loadProperties();
        }
        return this.properties;
    }

    private Properties loadProperties() {
        Properties props = new Properties();
        CloudEnvironment cloudEnv = this.cloudEnv != null ? this.cloudEnv : new CloudEnvironment();
        List<Map<String, Object>> services = cloudEnv.getServices();
        for (Map<String, Object> map : services) {
            String name = String.valueOf(map.get("name"));
            Map ops = (Map)map.get("credentials");
            if (ops == null) continue;
            for (Map.Entry entry : ops.entrySet()) {
                props.put(name + "." + (String)entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        return props;
    }
}

