/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service;

import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.runtime.env.AbstractServiceInfo;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.cloudfoundry.runtime.env.CloudServiceException;

public abstract class AbstractServiceCreator<S, SI extends AbstractServiceInfo> {
    private CloudEnvironment cloudEnvironment;
    private Class<SI> serviceInfoClass;

    public AbstractServiceCreator(CloudEnvironment cloudEnvironment, Class<SI> serviceInfoClass) {
        this.cloudEnvironment = cloudEnvironment;
        this.serviceInfoClass = serviceInfoClass;
    }

    public abstract S createService(SI var1);

    public ServiceNameTuple<S> createSingletonService() {
        List<SI> serviceInfos = this.cloudEnvironment.getServiceInfos(this.serviceInfoClass);
        if (serviceInfos.size() != 1) {
            throw new CloudServiceException("Expected 1 service of " + this.serviceInfoClass + " type, but found " + serviceInfos.size());
        }
        AbstractServiceInfo singletonServiceInfo = (AbstractServiceInfo)serviceInfos.get(0);
        return new ServiceNameTuple<S>(this.createService(singletonServiceInfo), singletonServiceInfo.getServiceName());
    }

    public S createService(String serviceName) {
        SI serviceInfo = this.cloudEnvironment.getServiceInfo(serviceName, this.serviceInfoClass);
        if (serviceInfo != null) {
            return this.createService(serviceInfo);
        }
        return null;
    }

    public List<ServiceNameTuple<S>> createServices() {
        List<SI> serviceInfos = this.cloudEnvironment.getServiceInfos(this.serviceInfoClass);
        ArrayList<ServiceNameTuple<S>> services = new ArrayList<ServiceNameTuple<S>>();
        for (AbstractServiceInfo serviceInfo : serviceInfos) {
            services.add(new ServiceNameTuple<S>(this.createService(serviceInfo), serviceInfo.getServiceName()));
        }
        return services;
    }

    public static class ServiceNameTuple<S> {
        public S service;
        public String name;

        public ServiceNameTuple(S service, String name) {
            this.service = service;
            this.name = name;
        }
    }
}

