/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service.document;

import com.mongodb.Mongo;
import com.mongodb.MongoException;
import java.net.UnknownHostException;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.cloudfoundry.runtime.env.CloudServiceException;
import org.cloudfoundry.runtime.env.MongoServiceInfo;
import org.cloudfoundry.runtime.service.AbstractServiceCreator;

public class MongoServiceCreator
extends AbstractServiceCreator<Mongo, MongoServiceInfo> {
    public MongoServiceCreator(CloudEnvironment cloudEnvironment) {
        super(cloudEnvironment, MongoServiceInfo.class);
    }

    @Override
    public Mongo createService(MongoServiceInfo serviceInfo) {
        try {
            return new Mongo(serviceInfo.getHost(), serviceInfo.getPort());
        }
        catch (UnknownHostException e) {
            throw new CloudServiceException(e);
        }
        catch (MongoException e) {
            throw new CloudServiceException(e);
        }
    }
}

