/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cloudfoundry;

import java.util.List;
import java.util.Properties;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.cloudfoundry.runtime.env.MysqlServiceInfo;
import play.Logger;
import play.Play;
import play.PlayPlugin;

public class CloudFoundryDBPlugin
extends PlayPlugin {
    public static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    public CloudEnvironment cloudEnvironment = new CloudEnvironment();
    public List<MysqlServiceInfo> mysqlServices = this.cloudEnvironment.getServiceInfos(MysqlServiceInfo.class);

    public void onApplicationStart() {
        Properties p = Play.configuration;
        if (p.containsKey("db") || p.containsKey("db.url")) {
            Logger.warn((String)"[CloudFoundry] A database configuration already exists", (Object[])new Object[0]);
            return;
        }
        if (this.mysqlServices.size() == 0) {
            Logger.warn((String)"[CloudFoundry] There is no MySQL service bind to this application instance", (Object[])new Object[0]);
            return;
        }
        if (this.mysqlServices.size() > 1) {
            Logger.warn((String)"[CloudFoundry] There is more than one MySQL service bind to this application instance. Only the first will be used.", (Object[])new Object[0]);
        }
        MysqlServiceInfo mysqlServiceInfo = this.mysqlServices.get(0);
        p.put("db.driver", MYSQL_DRIVER);
        p.put("db.url", mysqlServiceInfo.getUrl());
        p.put("db.user", mysqlServiceInfo.getUserName());
        p.put("db.pass", mysqlServiceInfo.getPassword());
    }
}

