/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cloudfoundry;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudfoundry.org.codehaus.jackson.map.ObjectMapper;
import org.cloudfoundry.runtime.env.AbstractServiceInfo;
import org.cloudfoundry.runtime.env.ApplicationInstanceInfo;
import org.cloudfoundry.runtime.env.CloudServiceException;
import org.cloudfoundry.runtime.env.MysqlServiceInfo;
import org.cloudfoundry.runtime.env.RabbitServiceInfo;
import org.cloudfoundry.runtime.env.RedisServiceInfo;
import play.modules.cloudfoundry.MongoServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudEnvironment {
    private ObjectMapper objectMapper = new ObjectMapper();
    private EnvironmentAccessor environment = new EnvironmentAccessor();
    private static Map<Class<? extends AbstractServiceInfo>, String> serviceTypeToNameMap = new HashMap<Class<? extends AbstractServiceInfo>, String>();

    void setCloudEnvironment(EnvironmentAccessor environment) {
        this.environment = environment;
    }

    public String getValue(String key) {
        return this.environment.getValue(key);
    }

    public ApplicationInstanceInfo getInstanceInfo() {
        String instanceInfoString = this.getValue("VCAP_APPLICATION");
        if (instanceInfoString == null || instanceInfoString.trim().isEmpty()) {
            return null;
        }
        try {
            Map infoMap = (Map)this.objectMapper.readValue(instanceInfoString, Map.class);
            return new ApplicationInstanceInfo(infoMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getCloudApiUri() {
        ApplicationInstanceInfo instanceInfo = this.getInstanceInfo();
        if (instanceInfo == null) {
            throw new IllegalArgumentException("There is no cloud API urls in a non-cloud deployment");
        }
        List uris = instanceInfo.getUris();
        String defaultUri = (String)uris.get(0);
        return "api" + defaultUri.substring(defaultUri.indexOf("."));
    }

    private Map<String, List<Map<String, Object>>> getRawServices() {
        String servicesString = this.getValue("VCAP_SERVICES");
        if (servicesString == null || servicesString.length() == 0) {
            return new HashMap<String, List<Map<String, Object>>>();
        }
        try {
            return (Map)this.objectMapper.readValue(servicesString, Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Map<String, Object>> getServices() {
        Map<String, List<Map<String, Object>>> rawServices = this.getRawServices();
        ArrayList<Map<String, Object>> flatServices = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, List<Map<String, Object>>> entry : rawServices.entrySet()) {
            flatServices.addAll((Collection<Map<String, Object>>)entry.getValue());
        }
        return flatServices;
    }

    private Map<String, Object> getServiceDataByName(String name) {
        List<Map<String, Object>> services = this.getServices();
        for (Map<String, Object> service : services) {
            if (!service.get("name").equals(name)) continue;
            return service;
        }
        return null;
    }

    private List<Map<String, Object>> getServiceDataByServiceType(String type) {
        List<Map<String, Object>> services = this.getServices();
        ArrayList<Map<String, Object>> matchedServices = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> service : services) {
            if (!service.get("label").equals(type)) continue;
            matchedServices.add(service);
        }
        return matchedServices;
    }

    public <T extends AbstractServiceInfo> T getServiceInfo(String name, Class<T> serviceInfoType) {
        Map<String, Object> serviceInfoMap = this.getServiceDataByName(name);
        String typeName = serviceTypeToNameMap.get(serviceInfoType);
        if (serviceInfoMap.get("label").equals(typeName)) {
            return this.getServiceInfo(serviceInfoMap, serviceInfoType);
        }
        return null;
    }

    public List<? extends AbstractServiceInfo> getServiceInfos() {
        ArrayList<? extends AbstractServiceInfo> serviceInfos = new ArrayList<AbstractServiceInfo>();
        for (Map.Entry<Class<? extends AbstractServiceInfo>, String> serviceTypeToNameEntry : serviceTypeToNameMap.entrySet()) {
            serviceInfos.addAll(this.getServiceInfos(serviceTypeToNameEntry.getKey()));
        }
        return serviceInfos;
    }

    public <T extends AbstractServiceInfo> List<T> getServiceInfos(Class<T> serviceInfoType) {
        String typeName = serviceTypeToNameMap.get(serviceInfoType);
        List<Map<String, Object>> serviceInfoMaps = this.getServiceDataByServiceType(typeName);
        ArrayList<T> serviceInfos = new ArrayList<T>();
        for (Map<String, Object> serviceInfoMap : serviceInfoMaps) {
            serviceInfos.add(this.getServiceInfo(serviceInfoMap, serviceInfoType));
        }
        return serviceInfos;
    }

    private <T extends AbstractServiceInfo> T getServiceInfo(Map<String, Object> serviceInfoMap, Class<T> serviceInfoType) {
        try {
            Constructor<T> ctor = serviceInfoType.getConstructor(Map.class);
            return (T)((AbstractServiceInfo)ctor.newInstance(serviceInfoMap));
        }
        catch (Exception e) {
            throw new CloudServiceException("Failed to create service information for " + serviceInfoMap.get("name"), (Throwable)e);
        }
    }

    static {
        serviceTypeToNameMap.put(MysqlServiceInfo.class, "mysql-5.1");
        serviceTypeToNameMap.put(RedisServiceInfo.class, "redis-2.2");
        serviceTypeToNameMap.put(MongoServiceInfo.class, "mongodb-1.8");
        serviceTypeToNameMap.put(RabbitServiceInfo.class, "rabbitmq-2.4");
    }

    public static class EnvironmentAccessor {
        public String getValue(String key) {
            return System.getenv(key);
        }
    }
}

