/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cloudfoundry;

import java.util.List;
import java.util.Properties;
import org.cloudfoundry.runtime.env.MysqlServiceInfo;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.modules.cloudfoundry.CloudEnvironment;
import play.modules.cloudfoundry.MongoServiceInfo;

public class CloudFoundryDBPlugin
extends PlayPlugin {
    public static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    public CloudEnvironment cloudEnvironment = new CloudEnvironment();
    public List<MysqlServiceInfo> mysqlServices = this.cloudEnvironment.getServiceInfos(MysqlServiceInfo.class);
    public List<MongoServiceInfo> mongoServices = this.cloudEnvironment.getServiceInfos(MongoServiceInfo.class);

    public void onApplicationStart() {
        Properties p = Play.configuration;
        this.mysqlServiceConfig(p);
        this.mongoDBServiceConfig(p);
    }

    private void mysqlServiceConfig(Properties p) {
        if (this.mysqlServices.size() == 0) {
            Logger.info((String)"[CloudFoundry] There is no MySQL service bound to this application instance.", (Object[])new Object[0]);
            return;
        }
        if (p.containsKey("db") || p.containsKey("db.url")) {
            Logger.warn((String)"[CloudFoundry] A MySQL database configuration already exists. It will not be overriden.", (Object[])new Object[0]);
            return;
        }
        if (this.mysqlServices.size() > 1) {
            Logger.warn((String)"[CloudFoundry] There is more than one MySQL service bind to this application instance. Only the first will be used.", (Object[])new Object[0]);
        }
        MysqlServiceInfo mysqlServiceInfo = this.mysqlServices.get(0);
        p.put("db.driver", MYSQL_DRIVER);
        p.put("db.url", mysqlServiceInfo.getUrl());
        p.put("db.user", mysqlServiceInfo.getUserName());
        p.put("db.pass", mysqlServiceInfo.getPassword());
    }

    private void mongoDBServiceConfig(Properties p) {
        if (this.mongoServices.size() == 0) {
            Logger.info((String)"[CloudFoundry] There is no MongoDB service bound to this application instance.", (Object[])new Object[0]);
            return;
        }
        if (p.containsKey("morphia.db.host")) {
            Logger.warn((String)"[CloudFoundry] A MongoDB database configuration already exists. It will not be overriden.", (Object[])new Object[0]);
            return;
        }
        if (this.mongoServices.size() > 1) {
            Logger.warn((String)"[CloudFoundry] There is more than one MongoDB service bind to this application instance. Only the first will be used.", (Object[])new Object[0]);
        }
        MongoServiceInfo mongoServiceInfo = this.mongoServices.get(0);
        this.morphiaPluginConfig(p, mongoServiceInfo);
        this.mongoPluginConfig(p, mongoServiceInfo);
    }

    private void morphiaPluginConfig(Properties p, MongoServiceInfo mongoServiceInfo) {
        p.put("morphia.db.host", mongoServiceInfo.getHost());
        p.put("morphia.db.port", Integer.toString(mongoServiceInfo.getPort()));
        p.put("morphia.db.name", mongoServiceInfo.getDbName());
        p.put("morphia.db.username", mongoServiceInfo.getUserName());
        p.put("morphia.db.password", mongoServiceInfo.getPassword());
        if (!p.containsKey("morphia.id.type")) {
            p.put("morphia.id.type", "ObjectId");
        }
        if (!p.containsKey("morphia.defaultWriteConcern")) {
            p.put("morphia.defaultWriteConcern", "safe");
        }
    }

    private void mongoPluginConfig(Properties p, MongoServiceInfo mongoServiceInfo) {
        p.put("mongo.host", mongoServiceInfo.getHost());
        p.put("mongo.port", Integer.toString(mongoServiceInfo.getPort()));
        p.put("mongo.database", mongoServiceInfo.getDbName());
        p.put("mongo.username", mongoServiceInfo.getUserName());
        p.put("mongo.password", mongoServiceInfo.getPassword());
    }
}

