/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.type;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.cloudfoundry.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleType
extends JavaType {
    protected final LinkedHashMap<String, JavaType> _typeParameters;

    private SimpleType(Class<?> cls) {
        this(cls, null);
    }

    protected SimpleType(Class<?> cls, Map<String, JavaType> typeParams) {
        super(cls);
        this._typeParameters = typeParams == null || typeParams.size() == 0 ? null : new LinkedHashMap<String, JavaType>(typeParams);
    }

    @Override
    protected JavaType _narrow(Class<?> subclass) {
        return new SimpleType(subclass);
    }

    @Override
    public JavaType narrowContentsBy(Class<?> subclass) {
        throw new IllegalArgumentException("Internal error: SimpleType.narrowContentsBy() should never be called");
    }

    public static SimpleType construct(Class<?> cls, Map<String, JavaType> typeParams) {
        if (Map.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Can not construct SimpleType for a Map (class: " + cls.getName() + ")");
        }
        if (Collection.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Can not construct SimpleType for a Collection (class: " + cls.getName() + ")");
        }
        if (cls.isArray()) {
            throw new IllegalArgumentException("Can not construct SimpleType for an array (class: " + cls.getName() + ")");
        }
        return new SimpleType(cls, typeParams);
    }

    @Override
    public boolean isContainerType() {
        return false;
    }

    @Override
    public JavaType findVariableType(String name) {
        if (this._typeParameters != null) {
            return this._typeParameters.get(name);
        }
        return null;
    }

    @Override
    public String toString() {
        return "[simple type, class " + this._class.getName() + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        SimpleType other = (SimpleType)o;
        if (other._class != this._class) {
            return false;
        }
        if (this._typeParameters == null) {
            return other._typeParameters == null;
        }
        return this._typeParameters.equals(other._typeParameters);
    }
}

