/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service.relational;

import java.sql.DriverManager;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.cloudfoundry.runtime.env.CloudServiceException;
import org.cloudfoundry.runtime.env.MysqlServiceInfo;
import org.cloudfoundry.runtime.service.AbstractServiceCreator;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

public class MysqlServiceCreator
extends AbstractServiceCreator<DataSource, MysqlServiceInfo> {
    private static final String DRIVER_CLASS_NAME = "com.mysql.jdbc.Driver";
    private static final String VALIDATION_QUERY = "/* ping */ SELECT 1";

    public MysqlServiceCreator(CloudEnvironment cloudEnvironment) {
        super(cloudEnvironment, MysqlServiceInfo.class);
    }

    @Override
    public DataSource createService(MysqlServiceInfo serviceInfo) {
        try {
            Class.forName(DRIVER_CLASS_NAME);
            if (this.hasClass("org.apache.commons.dbcp.BasicDataSource")) {
                BasicDataSource ds = new BasicDataSource();
                ds.setDriverClassName(DRIVER_CLASS_NAME);
                ds.setUrl(serviceInfo.getUrl());
                ds.setUsername(serviceInfo.getUserName());
                ds.setPassword(serviceInfo.getPassword());
                ds.setValidationQuery(VALIDATION_QUERY);
                ds.setTestOnBorrow(true);
                return ds;
            }
            if (this.hasClass("org.apache.tomcat.dbcp.dbcp.BasicDataSource")) {
                org.apache.tomcat.dbcp.dbcp.BasicDataSource ds = new org.apache.tomcat.dbcp.dbcp.BasicDataSource();
                ds.setDriverClassName(DRIVER_CLASS_NAME);
                ds.setUrl(serviceInfo.getUrl());
                ds.setUsername(serviceInfo.getUserName());
                ds.setPassword(serviceInfo.getPassword());
                ds.setValidationQuery(VALIDATION_QUERY);
                ds.setTestOnBorrow(true);
                return ds;
            }
            return new SimpleDriverDataSource(DriverManager.getDriver(serviceInfo.getUrl()), serviceInfo.getUrl(), serviceInfo.getUserName(), serviceInfo.getPassword());
        }
        catch (Exception e) {
            throw new CloudServiceException("Failed to created cloud datasource for " + serviceInfo.getServiceName() + " service", e);
        }
    }

    private boolean hasClass(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

