/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cloudfoundry;

import java.util.List;
import java.util.Properties;
import org.cloudfoundry.runtime.env.AbstractServiceInfo;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.cloudfoundry.runtime.env.MongoServiceInfo;
import org.cloudfoundry.runtime.env.MysqlServiceInfo;
import org.cloudfoundry.runtime.env.PostgresqlServiceInfo;
import play.Logger;
import play.Play;
import play.PlayPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudFoundryDBPlugin
extends PlayPlugin {
    public static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    public static final String POSTGRESQL_DRIVER = "org.postgresql.Driver";
    public CloudEnvironment cloudEnvironment = new CloudEnvironment();
    public List<MysqlServiceInfo> mysqlServices = this.cloudEnvironment.getServiceInfos(MysqlServiceInfo.class);
    public List<MongoServiceInfo> mongoServices = this.cloudEnvironment.getServiceInfos(MongoServiceInfo.class);
    public List<PostgresqlServiceInfo> pgsqlServices = this.cloudEnvironment.getServiceInfos(PostgresqlServiceInfo.class);

    public void onApplicationStart() {
        Properties p = Play.configuration;
        this.mysqlServiceConfig(p);
        this.mongoDBServiceConfig(p);
        this.pgsqlServiceConfig(p);
    }

    private void mysqlServiceConfig(Properties p) {
        if (!this.checkPlaySQLConfig(p) || !this.checkServiceList(this.mysqlServices, "MySQL")) {
            return;
        }
        MysqlServiceInfo mysqlServiceInfo = this.mysqlServices.get(0);
        p.put("db.driver", MYSQL_DRIVER);
        p.put("db.url", mysqlServiceInfo.getUrl());
        p.put("db.user", mysqlServiceInfo.getUserName());
        p.put("db.pass", mysqlServiceInfo.getPassword());
    }

    private void mongoDBServiceConfig(Properties p) {
        if (!this.checkServiceList(this.mongoServices, "MongoDB")) {
            return;
        }
        MongoServiceInfo mongoServiceInfo = this.mongoServices.get(0);
        if (p.containsKey("morphia.db.host")) {
            Logger.warn((String)"[CloudFoundry] A Morphia configuration already exists. It will not be overriden.", (Object[])new Object[0]);
        } else {
            this.morphiaPluginConfig(p, mongoServiceInfo);
        }
        if (p.containsKey("mongo.host")) {
            Logger.warn((String)"[CloudFoundry] A MongoDB configuration already exists. It will not be overriden.", (Object[])new Object[0]);
        } else {
            this.mongoPluginConfig(p, mongoServiceInfo);
        }
    }

    private void morphiaPluginConfig(Properties p, MongoServiceInfo mongoServiceInfo) {
        p.put("morphia.db.host", mongoServiceInfo.getHost());
        p.put("morphia.db.port", Integer.toString(mongoServiceInfo.getPort()));
        p.put("morphia.db.name", mongoServiceInfo.getDatabase());
        p.put("morphia.db.username", mongoServiceInfo.getUserName());
        p.put("morphia.db.password", mongoServiceInfo.getPassword());
        if (!p.containsKey("morphia.id.type")) {
            p.put("morphia.id.type", "ObjectId");
        }
        if (!p.containsKey("morphia.defaultWriteConcern")) {
            p.put("morphia.defaultWriteConcern", "safe");
        }
    }

    private void mongoPluginConfig(Properties p, MongoServiceInfo mongoServiceInfo) {
        p.put("mongo.host", mongoServiceInfo.getHost());
        p.put("mongo.port", Integer.toString(mongoServiceInfo.getPort()));
        p.put("mongo.database", mongoServiceInfo.getDatabase());
        p.put("mongo.username", mongoServiceInfo.getUserName());
        p.put("mongo.password", mongoServiceInfo.getPassword());
    }

    private void pgsqlServiceConfig(Properties p) {
        if (!this.checkPlaySQLConfig(p) || !this.checkServiceList(this.pgsqlServices, "PostgreSQL")) {
            return;
        }
        PostgresqlServiceInfo pgsqlServiceInfo = this.pgsqlServices.get(0);
        p.put("db.driver", POSTGRESQL_DRIVER);
        p.put("db.url", pgsqlServiceInfo.getUrl());
        p.put("db.user", pgsqlServiceInfo.getUserName());
        p.put("db.pass", pgsqlServiceInfo.getPassword());
    }

    private boolean checkServiceList(List<? extends AbstractServiceInfo> serviceInfos, String dbName) {
        if (serviceInfos.size() == 0) {
            Logger.info((String)"[CloudFoundry] There is no %s service bound to this application instance.", (Object[])new Object[]{dbName});
            return false;
        }
        if (serviceInfos.size() > 1) {
            Logger.warn((String)"[CloudFoundry] There is more than one %s service bind to this application instance. Only the first will be used.", (Object[])new Object[]{dbName});
        }
        return true;
    }

    private boolean checkPlaySQLConfig(Properties p) {
        if (p.containsKey("db") || p.containsKey("db.url")) {
            Logger.warn((String)"[CloudFoundry] A SQL database configuration already exists. It will not be overriden.", (Object[])new Object[0]);
            return false;
        }
        return true;
    }
}

