/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.util.Collection;
import org.cloudfoundry.org.codehaus.jackson.JsonParser;
import org.cloudfoundry.org.codehaus.jackson.JsonProcessingException;
import org.cloudfoundry.org.codehaus.jackson.JsonToken;
import org.cloudfoundry.org.codehaus.jackson.map.DeserializationContext;
import org.cloudfoundry.org.codehaus.jackson.map.JsonDeserializer;
import org.cloudfoundry.org.codehaus.jackson.map.deser.StdDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionDeserializer
extends StdDeserializer<Collection<Object>> {
    final Class<Collection<Object>> _collectionClass;
    final JsonDeserializer<Object> _valueDeserializer;

    public CollectionDeserializer(Class<?> collectionClass, JsonDeserializer<Object> valueDeser) {
        super(collectionClass);
        this._collectionClass = collectionClass;
        this._valueDeserializer = valueDeser;
    }

    @Override
    public Collection<Object> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Collection<Object> result;
        try {
            result = this._collectionClass.newInstance();
        }
        catch (Exception e) {
            throw ctxt.instantiationException(this._collectionClass, e);
        }
        return this.deserialize(jp, ctxt, result);
    }

    @Override
    public Collection<Object> deserialize(JsonParser jp, DeserializationContext ctxt, Collection<Object> result) throws IOException, JsonProcessingException {
        JsonToken t;
        if (jp.getCurrentToken() != JsonToken.START_ARRAY) {
            throw ctxt.mappingException(this._collectionClass);
        }
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        while ((t = jp.nextToken()) != JsonToken.END_ARRAY) {
            Object value = t == JsonToken.VALUE_NULL ? null : valueDes.deserialize(jp, ctxt);
            result.add(value);
        }
        return result;
    }
}

