/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.deser;

import java.lang.reflect.Member;
import org.cloudfoundry.org.codehaus.jackson.map.deser.Creator;
import org.cloudfoundry.org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotatedConstructor;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.cloudfoundry.org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatorContainer {
    final Class<?> _beanClass;
    final boolean _canFixAccess;
    AnnotatedMethod _strFactory;
    AnnotatedMethod _intFactory;
    AnnotatedMethod _longFactory;
    AnnotatedMethod _delegatingFactory;
    AnnotatedMethod _propertyBasedFactory;
    SettableBeanProperty[] _propertyBasedFactoryProperties = null;
    AnnotatedConstructor _strConstructor;
    AnnotatedConstructor _intConstructor;
    AnnotatedConstructor _longConstructor;
    AnnotatedConstructor _delegatingConstructor;
    AnnotatedConstructor _propertyBasedConstructor;
    SettableBeanProperty[] _propertyBasedConstructorProperties = null;

    public CreatorContainer(Class<?> beanClass, boolean canFixAccess) {
        this._canFixAccess = canFixAccess;
        this._beanClass = beanClass;
    }

    public void addStringConstructor(AnnotatedConstructor ctor) {
        this._strConstructor = this.verifyNonDup(ctor, this._strConstructor, "String");
    }

    public void addIntConstructor(AnnotatedConstructor ctor) {
        this._intConstructor = this.verifyNonDup(ctor, this._intConstructor, "int");
    }

    public void addLongConstructor(AnnotatedConstructor ctor) {
        this._longConstructor = this.verifyNonDup(ctor, this._longConstructor, "long");
    }

    public void addDelegatingConstructor(AnnotatedConstructor ctor) {
        this._delegatingConstructor = this.verifyNonDup(ctor, this._delegatingConstructor, "long");
    }

    public void addPropertyConstructor(AnnotatedConstructor ctor, SettableBeanProperty[] properties) {
        this._propertyBasedConstructor = this.verifyNonDup(ctor, this._propertyBasedConstructor, "property-based");
        this._propertyBasedConstructorProperties = properties;
    }

    public void addStringFactory(AnnotatedMethod factory) {
        this._strFactory = this.verifyNonDup(factory, this._strFactory, "String");
    }

    public void addIntFactory(AnnotatedMethod factory) {
        this._intFactory = this.verifyNonDup(factory, this._intFactory, "int");
    }

    public void addLongFactory(AnnotatedMethod factory) {
        this._longFactory = this.verifyNonDup(factory, this._longFactory, "long");
    }

    public void addDelegatingFactory(AnnotatedMethod factory) {
        this._delegatingFactory = this.verifyNonDup(factory, this._delegatingFactory, "long");
    }

    public void addPropertyFactory(AnnotatedMethod factory, SettableBeanProperty[] properties) {
        this._propertyBasedFactory = this.verifyNonDup(factory, this._propertyBasedFactory, "property-based");
        this._propertyBasedFactoryProperties = properties;
    }

    public Creator.StringBased stringCreator() {
        if (this._strConstructor == null && this._strFactory == null) {
            return null;
        }
        return new Creator.StringBased(this._beanClass, this._strConstructor, this._strFactory);
    }

    public Creator.NumberBased numberCreator() {
        if (this._intConstructor == null && this._intFactory == null && this._longConstructor == null && this._longFactory == null) {
            return null;
        }
        return new Creator.NumberBased(this._beanClass, this._intConstructor, this._intFactory, this._longConstructor, this._longFactory);
    }

    public Creator.Delegating delegatingCreator() {
        if (this._delegatingConstructor == null && this._delegatingFactory == null) {
            return null;
        }
        return new Creator.Delegating(this._delegatingConstructor, this._delegatingFactory);
    }

    public Creator.PropertyBased propertyBasedCreator() {
        if (this._propertyBasedConstructor == null && this._propertyBasedFactory == null) {
            return null;
        }
        return new Creator.PropertyBased(this._propertyBasedConstructor, this._propertyBasedConstructorProperties, this._propertyBasedFactory, this._propertyBasedFactoryProperties);
    }

    protected AnnotatedConstructor verifyNonDup(AnnotatedConstructor newOne, AnnotatedConstructor oldOne, String type) {
        if (oldOne != null) {
            throw new IllegalArgumentException("Conflicting " + type + " constructors: already had " + oldOne + ", encountered " + newOne);
        }
        if (this._canFixAccess) {
            ClassUtil.checkAndFixAccess((Member)((Object)newOne.getAnnotated()));
        }
        return newOne;
    }

    protected AnnotatedMethod verifyNonDup(AnnotatedMethod newOne, AnnotatedMethod oldOne, String type) {
        if (oldOne != null) {
            throw new IllegalArgumentException("Conflicting " + type + " factory methods: already had " + oldOne + ", encountered " + newOne);
        }
        if (this._canFixAccess) {
            ClassUtil.checkAndFixAccess(newOne.getAnnotated());
        }
        return newOne;
    }
}

