/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.introspect;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotatedWithParams;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotationMap;
import org.cloudfoundry.org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedMethod
extends AnnotatedWithParams {
    final Method _method;
    public Class<?>[] _paramTypes;

    public AnnotatedMethod(Method method, AnnotationMap classAnn, AnnotationMap[] paramAnn) {
        super(classAnn, paramAnn);
        this._method = method;
    }

    @Override
    public Method getAnnotated() {
        return this._method;
    }

    @Override
    public int getModifiers() {
        return this._method.getModifiers();
    }

    @Override
    public String getName() {
        return this._method.getName();
    }

    @Override
    public Class<?> getType() {
        return this.getReturnType();
    }

    @Override
    public AnnotatedParameter getParameter(int index) {
        return new AnnotatedParameter(this.getParameterType(index), this._paramAnnotations[index]);
    }

    @Override
    public int getParameterCount() {
        return this.getParameterTypes().length;
    }

    public Type[] getParameterTypes() {
        return this._method.getGenericParameterTypes();
    }

    @Override
    public Class<?> getParameterClass(int index) {
        Class<?>[] types = this._method.getParameterTypes();
        return index >= types.length ? null : types[index];
    }

    @Override
    public Type getParameterType(int index) {
        Type[] types = this._method.getGenericParameterTypes();
        return index >= types.length ? null : types[index];
    }

    public Class<?>[] getParameterClasses() {
        if (this._paramTypes == null) {
            this._paramTypes = this._method.getParameterTypes();
        }
        return this._paramTypes;
    }

    public Type getGenericReturnType() {
        return this._method.getGenericReturnType();
    }

    public Class<?> getReturnType() {
        return this._method.getReturnType();
    }

    public Class<?> getDeclaringClass() {
        return this._method.getDeclaringClass();
    }

    public String getFullName() {
        return this.getDeclaringClass().getName() + "#" + this.getName() + "(" + this.getParameterCount() + " params)";
    }

    public void fixAccess() {
        ClassUtil.checkAndFixAccess(this._method);
    }

    public String toString() {
        return "[method " + this.getName() + ", annotations: " + this._classAnnotations + "]";
    }
}

