/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.env;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Map;
import org.cloudfoundry.runtime.env.AbstractServiceInfo;

public class RabbitServiceInfo
extends AbstractServiceInfo {
    private String host;
    private int port;
    private String password;
    private String virtualHost;
    private String userName;

    public RabbitServiceInfo(Map<String, Object> serviceInfo) throws URISyntaxException {
        super(serviceInfo);
        Map credentials = (Map)serviceInfo.get("credentials");
        String uri = (String)credentials.get("url");
        if (uri != null) {
            this.parseAmqpUri(uri);
        } else {
            this.host = (String)credentials.get("hostname");
            this.port = (Integer)credentials.get("port");
            this.password = (String)credentials.get("pass");
            this.userName = (String)credentials.get("user");
            this.virtualHost = (String)credentials.get("vhost");
        }
    }

    private void parseAmqpUri(String uristr) throws URISyntaxException {
        String userInfo;
        URI uri = new URI(uristr);
        if (!"amqp".equals(uri.getScheme())) {
            throw new IllegalArgumentException("wrong scheme in amqp URI: " + uristr);
        }
        this.host = uri.getHost();
        if (this.host == null) {
            throw new IllegalArgumentException("missing authority in amqp URI: " + uristr);
        }
        this.port = uri.getPort();
        if (this.port == -1) {
            this.port = 5672;
        }
        if ((userInfo = uri.getRawUserInfo()) != null) {
            String[] userPass = userInfo.split(":");
            if (userPass.length != 2) {
                throw new IllegalArgumentException("bad user info in amqp URI: " + uristr);
            }
            this.userName = this.uriDecode(userPass[0]);
            this.password = this.uriDecode(userPass[1]);
        } else {
            this.userName = "guest";
            this.password = "guest";
        }
        String path = uri.getRawPath();
        if (path == null || path.length() == 0) {
            this.virtualHost = "/";
        } else {
            if (path.indexOf(47, 1) != -1) {
                throw new IllegalArgumentException("multiple segemtns in path of amqp URI: " + uristr);
            }
            this.virtualHost = uri.getPath().substring(1);
        }
    }

    private String uriDecode(String s) {
        try {
            return URLDecoder.decode(s.replace("+", "%2B"), "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public String getUserName() {
        return this.userName;
    }
}

