/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service;

import java.sql.DriverManager;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.cloudfoundry.runtime.env.AbstractDataSourceServiceInfo;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.cloudfoundry.runtime.env.CloudServiceException;
import org.cloudfoundry.runtime.service.AbstractServiceCreator;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

public abstract class AbstractDataSourceCreator<SI extends AbstractDataSourceServiceInfo>
extends AbstractServiceCreator<DataSource, SI> {
    public AbstractDataSourceCreator(CloudEnvironment cloudEnvironment, Class<SI> serviceInfoClass) {
        super(cloudEnvironment, serviceInfoClass);
    }

    public abstract String getDriverClassName();

    public abstract String getValidationQuery();

    @Override
    public DataSource createService(AbstractDataSourceServiceInfo serviceInfo) {
        try {
            Class.forName(this.getDriverClassName());
            if (this.hasClass("org.apache.commons.dbcp.BasicDataSource")) {
                BasicDataSource ds = new BasicDataSource();
                ds.setDriverClassName(this.getDriverClassName());
                ds.setUrl(serviceInfo.getUrl());
                ds.setUsername(serviceInfo.getUserName());
                ds.setPassword(serviceInfo.getPassword());
                if (this.getValidationQuery() != null) {
                    ds.setValidationQuery(this.getValidationQuery());
                    ds.setTestOnBorrow(true);
                }
                return ds;
            }
            if (this.hasClass("org.apache.tomcat.dbcp.dbcp.BasicDataSource")) {
                org.apache.tomcat.dbcp.dbcp.BasicDataSource ds = new org.apache.tomcat.dbcp.dbcp.BasicDataSource();
                ds.setDriverClassName(this.getDriverClassName());
                ds.setUrl(serviceInfo.getUrl());
                ds.setUsername(serviceInfo.getUserName());
                ds.setPassword(serviceInfo.getPassword());
                if (this.getValidationQuery() != null) {
                    ds.setValidationQuery(this.getValidationQuery());
                    ds.setTestOnBorrow(true);
                }
                return ds;
            }
            return new SimpleDriverDataSource(DriverManager.getDriver(serviceInfo.getUrl()), serviceInfo.getUrl(), serviceInfo.getUserName(), serviceInfo.getPassword());
        }
        catch (Exception e) {
            throw new CloudServiceException("Failed to created cloud datasource for " + serviceInfo.getServiceName() + " service", e);
        }
    }

    private boolean hasClass(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }
}

