/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.cloudfoundry.runtime.env.CloudEnvironment;
import org.cloudfoundry.runtime.env.CloudServiceException;
import org.cloudfoundry.runtime.service.AbstractServiceCreator;
import org.cloudfoundry.runtime.service.document.MongoServiceCreator;
import org.cloudfoundry.runtime.service.keyvalue.RedisServiceCreator;
import org.cloudfoundry.runtime.service.messaging.RabbitServiceCreator;
import org.cloudfoundry.runtime.service.relational.MysqlServiceCreator;
import org.cloudfoundry.runtime.service.relational.PostgresqlServiceCreator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class CloudServicesAutoPopulator
implements BeanFactoryPostProcessor {
    Logger logger = Logger.getLogger(CloudServicesAutoPopulator.class.getName());

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        CloudEnvironment cloudEnvironment;
        String[] envBeans = beanFactory.getBeanNamesForType(CloudEnvironment.class);
        if (envBeans.length == 0) {
            cloudEnvironment = new CloudEnvironment();
            beanFactory.registerSingleton("cloud-environment", (Object)cloudEnvironment);
        } else if (envBeans.length == 1) {
            cloudEnvironment = (CloudEnvironment)beanFactory.getBean(CloudEnvironment.class);
        } else {
            throw new CloudServiceException("CloudServicesAutoPopulator expects 0 or 1 bean of CloudEnvironment, found " + envBeans.length);
        }
        ArrayList<AbstractServiceCreator> serviceCreators = new ArrayList<AbstractServiceCreator>();
        serviceCreators.add(new MysqlServiceCreator(cloudEnvironment));
        serviceCreators.add(new PostgresqlServiceCreator(cloudEnvironment));
        serviceCreators.add(new RedisServiceCreator(cloudEnvironment));
        serviceCreators.add(new RabbitServiceCreator(cloudEnvironment));
        serviceCreators.add(new MongoServiceCreator(cloudEnvironment));
        this.logger.info("Auto-creating service beans");
        for (AbstractServiceCreator serviceCreator : serviceCreators) {
            List serviceNamePairs = serviceCreator.createServices();
            for (AbstractServiceCreator.ServiceNameTuple serviceNamePair : serviceNamePairs) {
                this.logger.info("Auto-creating service bean for " + serviceNamePair.name);
                beanFactory.registerSingleton(serviceNamePair.name, serviceNamePair.service);
            }
        }
    }
}

