/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.deser;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.cloudfoundry.org.codehaus.jackson.JsonNode;
import org.cloudfoundry.org.codehaus.jackson.map.AnnotationIntrospector;
import org.cloudfoundry.org.codehaus.jackson.map.DeserializationConfig;
import org.cloudfoundry.org.codehaus.jackson.map.DeserializerFactory;
import org.cloudfoundry.org.codehaus.jackson.map.DeserializerProvider;
import org.cloudfoundry.org.codehaus.jackson.map.JsonDeserializer;
import org.cloudfoundry.org.codehaus.jackson.map.JsonMappingException;
import org.cloudfoundry.org.codehaus.jackson.map.KeyDeserializer;
import org.cloudfoundry.org.codehaus.jackson.map.ResolvableDeserializer;
import org.cloudfoundry.org.codehaus.jackson.map.deser.BeanDeserializerFactory;
import org.cloudfoundry.org.codehaus.jackson.map.deser.StdKeyDeserializers;
import org.cloudfoundry.org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.cloudfoundry.org.codehaus.jackson.map.type.ArrayType;
import org.cloudfoundry.org.codehaus.jackson.map.type.CollectionType;
import org.cloudfoundry.org.codehaus.jackson.map.type.MapType;
import org.cloudfoundry.org.codehaus.jackson.map.type.TypeFactory;
import org.cloudfoundry.org.codehaus.jackson.map.util.ClassUtil;
import org.cloudfoundry.org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdDeserializerProvider
extends DeserializerProvider {
    private static final JavaType _typeObject = TypeFactory.type(Object.class);
    private static final JavaType _typeString = TypeFactory.type(String.class);
    static final HashMap<JavaType, KeyDeserializer> _keyDeserializers = StdKeyDeserializers.constructAll();
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers = new ConcurrentHashMap(64, 0.75f, 2);
    DeserializerFactory _factory;

    public StdDeserializerProvider() {
        this(BeanDeserializerFactory.instance);
    }

    public StdDeserializerProvider(DeserializerFactory f) {
        this._factory = f;
    }

    @Override
    public JsonDeserializer<Object> findValueDeserializer(DeserializationConfig config, JavaType type, JavaType referrer, String refPropName) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._findCachedDeserializer(type);
        if (deser != null) {
            return deser;
        }
        deser = this._createAndCacheValueDeserializer(config, type, referrer, refPropName);
        if (deser == null) {
            deser = this._handleUnknownValueDeserializer(type);
        }
        return deser;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(DeserializationConfig config, JavaType type) throws JsonMappingException {
        if (_typeString.equals(type) || _typeObject.equals(type)) {
            return null;
        }
        KeyDeserializer kdes = _keyDeserializers.get(type);
        if (kdes != null) {
            return kdes;
        }
        if (type.isEnumType()) {
            return StdKeyDeserializers.constructEnumKeyDeserializer(config, type);
        }
        kdes = StdKeyDeserializers.findStringBasedKeyDeserializer(config, type);
        if (kdes != null) {
            return kdes;
        }
        return this._handleUnknownKeyDeserializer(type);
    }

    @Override
    public boolean hasValueDeserializerFor(DeserializationConfig config, JavaType type) {
        JsonDeserializer<Object> deser = this._findCachedDeserializer(type);
        if (deser == null) {
            try {
                deser = this._createAndCacheValueDeserializer(config, type, null, null);
            }
            catch (Exception e) {
                return false;
            }
        }
        return deser != null;
    }

    @Override
    public int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    @Override
    public void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    protected JsonDeserializer<Object> _findCachedDeserializer(JavaType type) {
        return this._cachedDeserializers.get(type);
    }

    protected JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationConfig config, JavaType type, JavaType referrer, String refPropName) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        try {
            deser = this._createDeserializer(config, type, referrer, refPropName);
        }
        catch (IllegalArgumentException iae) {
            throw new JsonMappingException(iae.getMessage(), null, iae);
        }
        if (deser != null) {
            Boolean needToCache;
            AnnotationIntrospector aintr = config.getAnnotationIntrospector();
            AnnotatedClass ac = AnnotatedClass.construct(deser.getClass(), aintr, null);
            boolean isResolvable = deser instanceof ResolvableDeserializer;
            Boolean bl = needToCache = isResolvable ? null : aintr.findCachability(ac);
            if (isResolvable || needToCache != null && needToCache.booleanValue()) {
                this._cachedDeserializers.put(type, deser);
            }
            if (isResolvable) {
                this._resolveDeserializer(config, (ResolvableDeserializer)((Object)deser));
            }
        }
        return deser;
    }

    protected JsonDeserializer<Object> _createDeserializer(DeserializationConfig config, JavaType type, JavaType referrer, String refPropName) throws JsonMappingException {
        Class<?> rawClass;
        if (type.isEnumType()) {
            return this._factory.createEnumDeserializer(config, type.getRawClass(), this);
        }
        if (type.isContainerType()) {
            if (type instanceof ArrayType) {
                return this._factory.createArrayDeserializer(config, (ArrayType)type, this);
            }
            if (type instanceof MapType) {
                return this._factory.createMapDeserializer(config, (MapType)type, this);
            }
            if (type instanceof CollectionType) {
                return this._factory.createCollectionDeserializer(config, (CollectionType)type, this);
            }
        }
        if (JsonNode.class.isAssignableFrom(rawClass = type.getRawClass())) {
            Class<?> nodeClass = rawClass;
            return this._factory.createTreeDeserializer(config, nodeClass, this);
        }
        return this._factory.createBeanDeserializer(config, type, this);
    }

    protected void _resolveDeserializer(DeserializationConfig config, ResolvableDeserializer ser) throws JsonMappingException {
        ser.resolve(config, this);
    }

    protected JsonDeserializer<Object> _handleUnknownValueDeserializer(JavaType type) throws JsonMappingException {
        Class<?> rawClass = type.getRawClass();
        if (!ClassUtil.isConcrete(rawClass)) {
            throw new JsonMappingException("Can not find a Value deserializer for abstract type " + type);
        }
        throw new JsonMappingException("Can not find a Value deserializer for type " + type);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(JavaType type) throws JsonMappingException {
        throw new JsonMappingException("Can not find a (Map) Key deserializer for type " + type);
    }
}

