/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.org.codehaus.jackson.map.deser;

import java.io.IOException;
import org.cloudfoundry.org.codehaus.jackson.JsonParser;
import org.cloudfoundry.org.codehaus.jackson.JsonProcessingException;
import org.cloudfoundry.org.codehaus.jackson.JsonToken;
import org.cloudfoundry.org.codehaus.jackson.map.DeserializationContext;
import org.cloudfoundry.org.codehaus.jackson.map.JsonMappingException;
import org.cloudfoundry.org.codehaus.jackson.map.deser.BeanDeserializer;
import org.cloudfoundry.org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.cloudfoundry.org.codehaus.jackson.type.JavaType;

public class ThrowableDeserializer
extends BeanDeserializer {
    static final String PROP_NAME_MESSAGE = "message";

    public ThrowableDeserializer(JavaType type) {
        super(type);
    }

    public void validateCreators() {
        if (this._stringCreator == null) {
            throw new IllegalArgumentException("Can not create Throwable deserializer for (" + this._beanType + "): no single-String Creator (constructor, factory method) found");
        }
    }

    public Object deserializeFromObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object throwable = null;
        Object[] pending = null;
        int pendingIx = 0;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String propName = jp.getCurrentName();
            SettableBeanProperty prop = (SettableBeanProperty)this._props.get(propName);
            if (prop != null) {
                if (throwable != null) {
                    prop.deserializeAndSet(jp, ctxt, throwable);
                    continue;
                }
                if (pending == null) {
                    int len = this._props.size();
                    pending = new Object[len + len];
                }
                pending[pendingIx++] = prop;
                pending[pendingIx++] = prop.deserialize(jp, ctxt);
                continue;
            }
            JsonToken t = jp.nextToken();
            if (PROP_NAME_MESSAGE.equals(propName)) {
                throwable = this._stringCreator.construct(jp.getText());
                if (pending == null) continue;
                int len = pendingIx;
                for (int i = 0; i < len; i += 2) {
                    prop = (SettableBeanProperty)pending[i];
                    prop.set(throwable, pending[i + 1]);
                }
                pending = null;
                continue;
            }
            this.handleUnknownProperty(ctxt, throwable, propName);
        }
        if (throwable == null) {
            throw new JsonMappingException("No 'message' property found: could not deserialize " + this._beanType);
        }
        return throwable;
    }
}

