/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.env;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.cloudfoundry.org.codehaus.jackson.map.ObjectMapper;
import org.cloudfoundry.runtime.env.AbstractServiceInfo;
import org.cloudfoundry.runtime.env.ApplicationInstanceInfo;
import org.cloudfoundry.runtime.env.CloudServiceException;
import org.cloudfoundry.runtime.env.MongoServiceInfo;
import org.cloudfoundry.runtime.env.RabbitServiceInfo;
import org.cloudfoundry.runtime.env.RdbmsServiceInfo;
import org.cloudfoundry.runtime.env.RedisServiceInfo;

public class CloudEnvironment {
    private ObjectMapper objectMapper = new ObjectMapper();
    private EnvironmentAccessor environment = new EnvironmentAccessor();
    private static Map<Class<? extends AbstractServiceInfo>, Set<String>> serviceTypeToLabels = new HashMap<Class<? extends AbstractServiceInfo>, Set<String>>();

    private static void labelledServiceType(Class<? extends AbstractServiceInfo> serviceType, String label) {
        Set<String> labels = serviceTypeToLabels.get(serviceType);
        if (labels == null) {
            labels = new HashSet<String>();
            serviceTypeToLabels.put(serviceType, labels);
        }
        labels.add(label);
    }

    void setCloudEnvironment(EnvironmentAccessor environment) {
        this.environment = environment;
    }

    public String getValue(String key) {
        return this.environment.getValue(key);
    }

    public boolean isCloudFoundry() {
        return this.getValue("VCAP_APPLICATION") != null;
    }

    public ApplicationInstanceInfo getInstanceInfo() {
        String instanceInfoString = this.getValue("VCAP_APPLICATION");
        if (instanceInfoString == null || instanceInfoString.trim().isEmpty()) {
            return null;
        }
        try {
            Map infoMap = this.objectMapper.readValue(instanceInfoString, Map.class);
            return new ApplicationInstanceInfo(infoMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getCloudApiUri() {
        ApplicationInstanceInfo instanceInfo = this.getInstanceInfo();
        if (instanceInfo == null) {
            throw new IllegalArgumentException("There is no cloud API urls in a non-cloud deployment");
        }
        List<String> uris = instanceInfo.getUris();
        String defaultUri = uris.get(0);
        return "api" + defaultUri.substring(defaultUri.indexOf("."));
    }

    private Map<String, List<Map<String, Object>>> getRawServices() {
        String servicesString = this.getValue("VCAP_SERVICES");
        if (servicesString == null || servicesString.length() == 0) {
            return new HashMap<String, List<Map<String, Object>>>();
        }
        try {
            return this.objectMapper.readValue(servicesString, Map.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<Map<String, Object>> getServices() {
        Map<String, List<Map<String, Object>>> rawServices = this.getRawServices();
        ArrayList<Map<String, Object>> flatServices = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, List<Map<String, Object>>> entry : rawServices.entrySet()) {
            flatServices.addAll((Collection<Map<String, Object>>)entry.getValue());
        }
        return flatServices;
    }

    private Map<String, Object> getServiceDataByName(String name) {
        List<Map<String, Object>> services = this.getServices();
        for (Map<String, Object> service : services) {
            if (!service.get("name").equals(name)) continue;
            return service;
        }
        return null;
    }

    private List<Map<String, Object>> getServiceDataByLabels(Set<String> labels) {
        List<Map<String, Object>> services = this.getServices();
        ArrayList<Map<String, Object>> matchedServices = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> service : services) {
            if (!labels.contains(service.get("label"))) continue;
            matchedServices.add(service);
        }
        return matchedServices;
    }

    public <T extends AbstractServiceInfo> T getServiceInfo(String name, Class<T> serviceInfoType) {
        Map<String, Object> serviceInfoMap = this.getServiceDataByName(name);
        Set<String> labels = serviceTypeToLabels.get(serviceInfoType);
        if (labels != null && labels.contains(serviceInfoMap.get("label"))) {
            return this.getServiceInfo(serviceInfoMap, serviceInfoType);
        }
        return null;
    }

    public <T extends AbstractServiceInfo> List<T> getServiceInfos(Class<T> serviceInfoType) {
        Set<String> labels = serviceTypeToLabels.get(serviceInfoType);
        ArrayList<T> serviceInfos = new ArrayList<T>();
        if (labels != null) {
            List<Map<String, Object>> serviceInfoMaps = this.getServiceDataByLabels(labels);
            for (Map<String, Object> serviceInfoMap : serviceInfoMaps) {
                serviceInfos.add(this.getServiceInfo(serviceInfoMap, serviceInfoType));
            }
        }
        return serviceInfos;
    }

    private <T extends AbstractServiceInfo> T getServiceInfo(Map<String, Object> serviceInfoMap, Class<T> serviceInfoType) {
        try {
            Constructor<T> ctor = serviceInfoType.getConstructor(Map.class);
            return (T)((AbstractServiceInfo)ctor.newInstance(serviceInfoMap));
        }
        catch (Exception e) {
            throw new CloudServiceException("Failed to create service information for " + serviceInfoMap.get("name"), e);
        }
    }

    public Properties getCloudProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.providerProperties());
        properties.putAll((Map<?, ?>)this.applicationProperties());
        properties.putAll((Map<?, ?>)this.serviceProperties());
        return properties;
    }

    private Properties providerProperties() {
        Properties properties = new Properties();
        properties.put("cloud.provider.url", this.getCloudApiUri().split("\\.", 2)[1]);
        return properties;
    }

    private Properties applicationProperties() {
        Properties properties = new Properties();
        properties.put("cloud.application.name", this.getInstanceInfo().getName());
        return properties;
    }

    private Properties serviceProperties() {
        String shortType;
        Properties properties = new Properties();
        HashMap<String, Integer> serviceCounts = new HashMap<String, Integer>();
        List<Map<String, Object>> services = this.getServices();
        for (Map<String, Object> service : services) {
            shortType = this.serviceShortType(service);
            properties.putAll((Map<?, ?>)this.servicePropertiesHelper("cloud.services." + service.get("name"), service));
            int count = serviceCounts.containsKey(shortType) ? (Integer)serviceCounts.get(shortType) : 0;
            serviceCounts.put(shortType, count + 1);
        }
        for (Map<String, Object> service : services) {
            shortType = this.serviceShortType(service);
            if ((Integer)serviceCounts.get(shortType) != 1 || properties.containsKey("cloud.services." + shortType + ".type")) continue;
            properties.putAll((Map<?, ?>)this.servicePropertiesHelper("cloud.services." + shortType, service));
        }
        return properties;
    }

    private Properties servicePropertiesHelper(String propertyBase, Map<String, Object> service) {
        Properties source = new Properties();
        source.put(propertyBase + ".plan", service.get("plan").toString());
        source.put(propertyBase + ".type", service.get("label").toString());
        for (Map.Entry connectionProperty : ((Map)service.get("credentials")).entrySet()) {
            source.put(propertyBase + ".connection." + (String)connectionProperty.getKey(), connectionProperty.getValue().toString());
        }
        return source;
    }

    private String serviceShortType(Map<String, Object> service) {
        String type = (String)service.get("label");
        return type.split("-", 2)[0];
    }

    static {
        CloudEnvironment.labelledServiceType(RdbmsServiceInfo.class, "mysql-5.1");
        CloudEnvironment.labelledServiceType(RdbmsServiceInfo.class, "postgresql-9.0");
        CloudEnvironment.labelledServiceType(RedisServiceInfo.class, "redis-2.2");
        CloudEnvironment.labelledServiceType(MongoServiceInfo.class, "mongodb-1.8");
        CloudEnvironment.labelledServiceType(RabbitServiceInfo.class, "rabbitmq-2.4");
    }

    public static class EnvironmentAccessor {
        public String getValue(String key) {
            return System.getenv(key);
        }
    }
}

