/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service;

import java.sql.DriverManager;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.cloudfoundry.runtime.env.AbstractDataSourceServiceInfo;
import org.cloudfoundry.runtime.env.CloudServiceException;
import org.cloudfoundry.runtime.service.AbstractServiceCreator;
import org.cloudfoundry.runtime.service.CloudPoolConfiguration;
import org.cloudfoundry.runtime.service.relational.CloudConnectionConfiguration;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

public abstract class AbstractDataSourceCreator<SI extends AbstractDataSourceServiceInfo>
extends AbstractServiceCreator<DataSource, SI> {
    private CloudConnectionConfiguration cloudConnectionConfiguration;
    private CloudPoolConfiguration cloudPoolConfiguration;

    public abstract String getDriverClassName();

    public abstract String getValidationQuery();

    public void setCloudConnectionConfiguration(CloudConnectionConfiguration cloudConnectionConfiguration) {
        this.cloudConnectionConfiguration = cloudConnectionConfiguration;
    }

    public void setCloudPoolConfiguration(CloudPoolConfiguration cloudPoolConfiguration) {
        this.cloudPoolConfiguration = cloudPoolConfiguration;
    }

    @Override
    public DataSource createService(AbstractDataSourceServiceInfo serviceInfo) {
        try {
            Class.forName(this.getDriverClassName());
            if (this.hasClass("org.apache.commons.dbcp.BasicDataSource")) {
                BasicDataSource ds = new BasicDataSource();
                this.setBasicDataSourceProperties(ds, serviceInfo);
                return ds;
            }
            if (this.hasClass("org.apache.tomcat.dbcp.dbcp.BasicDataSource")) {
                org.apache.tomcat.dbcp.dbcp.BasicDataSource ds = new org.apache.tomcat.dbcp.dbcp.BasicDataSource();
                this.setBasicDataSourceProperties(ds, serviceInfo);
                return ds;
            }
            return new SimpleDriverDataSource(DriverManager.getDriver(serviceInfo.getUrl()), serviceInfo.getUrl(), serviceInfo.getUserName(), serviceInfo.getPassword());
        }
        catch (Exception e) {
            throw new CloudServiceException("Failed to created cloud datasource for " + serviceInfo.getServiceName() + " service", e);
        }
    }

    private void setBasicDataSourceProperties(Object basicDataSource, AbstractDataSourceServiceInfo serviceInfo) {
        BeanWrapperImpl target = new BeanWrapperImpl(basicDataSource);
        target.setPropertyValue("driverClassName", (Object)this.getDriverClassName());
        target.setPropertyValue("url", (Object)serviceInfo.getUrl());
        target.setPropertyValue("username", (Object)serviceInfo.getUserName());
        target.setPropertyValue("password", (Object)serviceInfo.getPassword());
        if (this.getValidationQuery() != null) {
            target.setPropertyValue("validationQuery", (Object)this.getValidationQuery());
            target.setPropertyValue("testOnBorrow", (Object)true);
        }
        if (this.cloudConnectionConfiguration != null) {
            BeanWrapperImpl connectionSource = new BeanWrapperImpl((Object)this.cloudConnectionConfiguration);
            this.setCorrespondingProperties((BeanWrapper)target, (BeanWrapper)connectionSource);
        }
        if (this.cloudPoolConfiguration != null) {
            BeanWrapperImpl poolSource = new BeanWrapperImpl((Object)this.cloudPoolConfiguration);
            this.setCorrespondingProperties((BeanWrapper)target, (BeanWrapper)poolSource);
        }
    }
}

