/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service.document;

import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.net.UnknownHostException;
import org.cloudfoundry.runtime.env.CloudServiceException;
import org.cloudfoundry.runtime.env.MongoServiceInfo;
import org.cloudfoundry.runtime.service.AbstractServiceCreator;
import org.cloudfoundry.runtime.service.document.CloudMongoConfiguration;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.SimpleMongoDbFactory;
import org.springframework.util.ReflectionUtils;

public class MongoServiceCreator
extends AbstractServiceCreator<MongoDbFactory, MongoServiceInfo> {
    private CloudMongoConfiguration cloudMongoConfiguration;

    public void setCloudMongoConfiguration(CloudMongoConfiguration cloudMongoConfiguration) {
        this.cloudMongoConfiguration = cloudMongoConfiguration;
    }

    @Override
    public MongoDbFactory createService(MongoServiceInfo serviceInfo) {
        try {
            WriteConcern writeConcern;
            UserCredentials credentials = new UserCredentials(serviceInfo.getUserName(), serviceInfo.getPassword());
            Mongo mongo = null;
            MongoOptions mongoOptionsToUse = this.getMongoOptions();
            if (mongoOptionsToUse != null) {
                ServerAddress serverAddress = new ServerAddress(serviceInfo.getHost(), serviceInfo.getPort());
                mongo = new Mongo(serverAddress, mongoOptionsToUse);
            } else {
                mongo = new Mongo(serviceInfo.getHost(), serviceInfo.getPort());
            }
            SimpleMongoDbFactory mongoDbFactory = new SimpleMongoDbFactory(mongo, serviceInfo.getDatabase(), credentials);
            if (this.cloudMongoConfiguration != null && this.cloudMongoConfiguration.getWriteConcern() != null && (writeConcern = WriteConcern.valueOf((String)this.cloudMongoConfiguration.getWriteConcern())) != null) {
                mongoDbFactory.setWriteConcern(writeConcern);
            }
            return mongoDbFactory;
        }
        catch (UnknownHostException e) {
            throw new CloudServiceException(e);
        }
        catch (MongoException e) {
            throw new CloudServiceException(e);
        }
    }

    private MongoOptions getMongoOptions() {
        if (this.cloudMongoConfiguration == null) {
            return null;
        }
        MongoOptions mongoOptions = null;
        BeanWrapperImpl source = new BeanWrapperImpl((Object)this.cloudMongoConfiguration);
        for (PropertyDescriptor pd : source.getPropertyDescriptors()) {
            Field field;
            String property = pd.getName();
            if ("class".equals(property) || !source.isReadableProperty(property) || source.getPropertyValue(property) == null || (field = ReflectionUtils.findField(MongoOptions.class, (String)property)) == null) continue;
            if (mongoOptions == null) {
                mongoOptions = new MongoOptions();
            }
            ReflectionUtils.setField((Field)field, (Object)mongoOptions, (Object)source.getPropertyValue(property));
        }
        return mongoOptions;
    }
}

