/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.runtime.service.keyvalue;

import org.cloudfoundry.runtime.env.CloudServiceException;
import org.cloudfoundry.runtime.env.RedisServiceInfo;
import org.cloudfoundry.runtime.service.AbstractServiceCreator;
import org.cloudfoundry.runtime.service.CloudPoolConfiguration;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import redis.clients.jedis.JedisPoolConfig;

public class RedisServiceCreator
extends AbstractServiceCreator<RedisConnectionFactory, RedisServiceInfo> {
    private static final String REDIS_CLIENT_CLASS_NAME = "redis.clients.jedis.Jedis";
    private CloudPoolConfiguration cloudPoolConfiguration;

    public void setCloudPoolConfiguration(CloudPoolConfiguration cloudPoolConfiguration) {
        this.cloudPoolConfiguration = cloudPoolConfiguration;
    }

    @Override
    public RedisConnectionFactory createService(RedisServiceInfo serviceInfo) {
        if (this.hasClass(REDIS_CLIENT_CLASS_NAME)) {
            JedisConnectionFactory connectionFactory = new JedisConnectionFactory();
            connectionFactory.setHostName(serviceInfo.getHost());
            connectionFactory.setPort(serviceInfo.getPort());
            connectionFactory.setPassword(serviceInfo.getPassword());
            JedisPoolConfig poolConfig = null;
            if (this.cloudPoolConfiguration != null) {
                poolConfig = new JedisPoolConfig();
                BeanWrapperImpl target = new BeanWrapperImpl((Object)poolConfig);
                BeanWrapperImpl source = new BeanWrapperImpl((Object)this.cloudPoolConfiguration);
                this.setCorrespondingProperties((BeanWrapper)target, (BeanWrapper)source);
            }
            if (poolConfig != null) {
                connectionFactory.setPoolConfig(poolConfig);
            }
            connectionFactory.afterPropertiesSet();
            return connectionFactory;
        }
        throw new CloudServiceException("Failed to created cloud Redis connection factory for " + serviceInfo.getServiceName() + " service.  Jedis client implementation class (" + REDIS_CLIENT_CLASS_NAME + ") not found");
    }
}

