/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cnm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.PlayPlugin;
import play.modules.cnm.MediaType;
import play.modules.cnm.Supports;
import play.mvc.Http;

public final class ContentNegotiationPlugin
extends PlayPlugin {
    private static final String ACCEPT_HEADER = "accept";
    private static final String ACCEPT_PATTERN = "q=([0-9\\.]+)";

    public void beforeActionInvocation(Method actionMethod) {
        if (this.supportsCustomType(actionMethod) && this.hasMatch(actionMethod, Http.Request.current().headers)) {
            Http.Request.current().format = this.findBestMatch(actionMethod, ((Http.Header)Http.Request.current().headers.get(ACCEPT_HEADER)).value());
        }
    }

    private boolean supportsCustomType(Method actionMethod) {
        return !(!actionMethod.isAnnotationPresent(Supports.class) && !actionMethod.getDeclaringClass().isAnnotationPresent(Supports.class) || actionMethod.getAnnotation(Supports.class).value().length <= 0 && actionMethod.getDeclaringClass().getAnnotation(Supports.class).value().length <= 0);
    }

    private boolean hasMatch(Method actionMethod, Map<String, Http.Header> headers) {
        return headers.containsKey(ACCEPT_HEADER) && !headers.get(ACCEPT_HEADER).toString().isEmpty() && this.findBestMatch(actionMethod, ((Http.Header)Http.Request.current().headers.get(ACCEPT_HEADER)).value()) != null;
    }

    private String findBestMatch(Method actionMethod, String header) {
        Map<String, String> supportedTypes = this.determineSupportedTypes(actionMethod);
        List<String> acceptedTypes = this.sortValues(Arrays.asList(header.split(",")));
        for (String type : acceptedTypes) {
            if (!supportedTypes.containsKey(type)) continue;
            return supportedTypes.get(type);
        }
        return null;
    }

    private Map<String, String> determineSupportedTypes(Method actionMethod) {
        HashMap<String, String> supportedTypes = new HashMap<String, String>();
        ArrayList<MediaType> methodTypes = new ArrayList<MediaType>();
        ArrayList<MediaType> classTypes = new ArrayList<MediaType>();
        if (actionMethod.isAnnotationPresent(Supports.class)) {
            methodTypes.addAll(Arrays.asList(actionMethod.getAnnotation(Supports.class).value()));
        }
        if (actionMethod.getDeclaringClass().isAnnotationPresent(Supports.class)) {
            classTypes.addAll(Arrays.asList(actionMethod.getDeclaringClass().getAnnotation(Supports.class).value()));
        }
        for (MediaType type : methodTypes) {
            supportedTypes.put(type.accept().trim(), type.format().trim());
        }
        for (MediaType type : classTypes) {
            supportedTypes.put(type.accept().trim(), type.format().trim());
        }
        return supportedTypes;
    }

    private List<String> sortValues(List<String> unsortedTypes) {
        final Pattern qpattern = Pattern.compile(ACCEPT_PATTERN);
        Collections.sort(unsortedTypes, new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                double q1 = 1.0;
                double q2 = 1.0;
                Matcher m1 = qpattern.matcher(first);
                Matcher m2 = qpattern.matcher(second);
                if (m1.find()) {
                    q1 = Double.parseDouble(m1.group(1));
                }
                if (m2.find()) {
                    q2 = Double.parseDouble(m2.group(1));
                }
                if (q1 > q2) {
                    return -1;
                }
                if (q1 == q2) {
                    return 0;
                }
                return 1;
            }
        });
        ArrayList<String> result = new ArrayList<String>(unsortedTypes.size());
        for (String string : unsortedTypes) {
            result.add(string.split(";")[0].trim());
        }
        return result;
    }
}

