/*
 * Project: play-content-negotiation
 * Package: play.modules.cnm
 * File   : MediaType.java
 * Created: 10.04.2011 - 14:12:18
 *
 *
 * Copyright 2011 Sebastian Hoß
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package play.modules.cnm;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>
 * Defines a media type.
 * </p>
 *
 * @author  Sebastian Hoß (mail@shoss.de)
 * @since   2.0
 */
@Inherited
@Target(value = {ElementType.TYPE, ElementType.METHOD})
@Retention(value = RetentionPolicy.RUNTIME)
public @interface MediaType {

    /** The matching accept header value. */
    String accept();

    /** The resulting Play! template format. */
    String format();

}
