/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cobertura;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.instrument.ClassInstrumenter;
import net.sourceforge.cobertura.reporting.Main;
import net.sourceforge.cobertura.util.FileLocker;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.vfs.VirtualFile;

public class CoberturaPlugin
extends PlayPlugin {
    public static final String REPORT_DIRECTORY = "test-result/code-coverage";
    private static int unsavedChanges = 0;
    private static boolean refreshAllClasses = false;
    private static String separator = System.getProperty("file.separator");
    static Collection ignoreRegexes = new Vector();
    static Collection ignoreBranchesRegexes = new Vector();
    static ProjectData projectData = null;
    static File dataFile;

    public void onLoad() {
        if (!Play.id.equals("test")) {
            return;
        }
        CoberturaPlugin.initCobertura();
        Runtime.getRuntime().addShutdownHook(new CoberturaPluginShutdownThread());
        Logger.trace((String)"Cobertura plugin: loaded", (Object[])new Object[0]);
    }

    public void onApplicationStart() {
        if (!Play.id.equals("test")) {
            return;
        }
        this.saveCoverageData();
    }

    public void detectChange() throws RuntimeException {
        if (unsavedChanges != 0) {
            unsavedChanges = 0;
            refreshAllClasses = true;
            throw new RuntimeException();
        }
    }

    public void onConfigurationRead() {
        if (!Play.id.equals("test")) {
            return;
        }
    }

    public void onApplicationStop() {
        if (refreshAllClasses) {
            throw new RuntimeException();
        }
    }

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) {
        ClassWriter classWriter;
        if (!Play.id.equals("test")) {
            return;
        }
        if (applicationClass.name.endsWith("Test") || applicationClass.name.equals("controllers.TestRunner")) {
            return;
        }
        Logger.trace((String)"Cobertura plugin: Instrumenting class %s", (Object[])new Object[]{applicationClass.name});
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(applicationClass.enhancedByteCode);
            ClassReader classReader = new ClassReader((InputStream)byteArrayInputStream);
            classWriter = new ClassWriter(1);
            ClassInstrumenter classInstrumenter = new ClassInstrumenter(projectData, (ClassVisitor)classWriter, ignoreRegexes, ignoreBranchesRegexes);
            classReader.accept((ClassVisitor)classInstrumenter, 0);
        }
        catch (Throwable throwable) {
            Logger.error((String)("Unable to instrument class " + applicationClass.name + " (" + throwable + ")"), (Object[])new Object[]{throwable});
            return;
        }
        applicationClass.enhancedByteCode = classWriter.toByteArray();
        ++unsavedChanges;
    }

    private static void initCobertura() {
        Logger.trace((String)"Cobertura plugin: initializing configuration and data", (Object[])new Object[0]);
        String string = Play.applicationPath.getAbsolutePath() + separator + "cobertura.ser";
        System.setProperty("net.sourceforge.cobertura.datafile", string);
        dataFile = CoverageDataFileHandler.getDefaultDataFile();
        if (dataFile.exists()) {
            dataFile.delete();
        }
        if (dataFile.isFile()) {
            projectData = CoverageDataFileHandler.loadCoverageData((File)dataFile);
        }
        if (projectData == null) {
            projectData = new ProjectData();
        }
    }

    private void saveCoverageData() {
        if (unsavedChanges > 0) {
            CoverageDataFileHandler.saveCoverageData((ProjectData)projectData, (File)dataFile);
            Logger.trace((String)"Cobertura plugin: saved coverage data for %d classes", (Object[])new Object[]{unsavedChanges});
            unsavedChanges = 0;
        }
    }

    private static void coberturaReport() {
        if (!new File(dataFile.getAbsolutePath()).exists()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--datafile");
        arrayList.add(dataFile.getAbsolutePath());
        arrayList.add("--destination");
        arrayList.add(Play.applicationPath + separator + REPORT_DIRECTORY);
        arrayList.add("--format");
        arrayList.add("placeholder");
        for (VirtualFile virtualFile : Play.javaPath) {
            arrayList.add(virtualFile.getRealFile().getAbsolutePath());
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        try {
            stringArray[5] = "xml";
            Main.main((String[])stringArray);
            stringArray[5] = "html";
            Main.main((String[])stringArray);
        }
        catch (Exception exception) {
            Logger.error((String)"Error generating the Cobertura report", (Object[])new Object[0]);
        }
    }

    class CoberturaPluginShutdownThread
    extends Thread {
        CoberturaPluginShutdownThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Logger.info((String)"Cobertura plugin: generating test coverage report", (Object[])new Object[0]);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            FileLocker fileLocker = new FileLocker(dataFile);
            try {
                if (fileLocker.lock()) {
                    CoberturaPlugin.coberturaReport();
                }
            }
            finally {
                fileLocker.release();
            }
            String string = new File(Play.applicationPath + separator + CoberturaPlugin.REPORT_DIRECTORY + separator + "index.html").toURI().toString();
            Logger.info((String)"Test coverage report has been generated: %s", (Object[])new Object[]{string});
        }
    }
}

