/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.javancss;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sourceforge.cobertura.javancss.FileUtil;
import net.sourceforge.cobertura.javancss.JavaParser;
import net.sourceforge.cobertura.javancss.JavaParserTokenManager;
import net.sourceforge.cobertura.javancss.JavancssConstants;
import net.sourceforge.cobertura.javancss.PackageMetric;
import net.sourceforge.cobertura.javancss.ParseException;
import net.sourceforge.cobertura.javancss.TokenMgrError;
import net.sourceforge.cobertura.javancss.Util;

public class Javancss
implements JavancssConstants {
    static final int LEN_NR = 3;
    static final String S_INIT__FILE_CONTENT = "[Init]\nAuthor=Chr. Clemens Lee\n\n[Help]\n; Please do not edit the Help section\nHelpUsage=@srcfiles.txt | *.java | <stdin>\nOptions=ncss,package,object,function,all,gui,xml,out,recursive,check\nncss=b,o,Counts the program NCSS (default).\npackage=b,o,Assembles a statistic on package level.\nobject=b,o,Counts the object NCSS.\nfunction=b,o,Counts the function NCSS.\nall=b,o,The same as '-function -object -package'.\ngui=b,o,Opens a gui to present the '-all' output in tabbed panels.\nxml=b,o,Output in xml format.\nout=s,o,Output file name. By default output goes to standard out.\nrecursive=b,o,Recurse to subdirs.\ncheck=b,o,Triggers a javancss self test.\n\n[Colors]\nUseSystemColors=true\n";
    private int _ncss = 0;
    private int _loc = 0;
    private JavaParser _pJavaParser = null;
    private Vector _vJavaSourceFiles = new Vector();
    private String _sErrorMessage = null;
    private Throwable _thrwError = null;
    private Vector _vFunctionMetrics = new Vector();
    private Vector _vObjectMetrics = new Vector();
    private Vector _vPackageMetrics = null;
    private Vector _vImports = null;
    private Hashtable _htPackages = null;
    private Hashtable _htProcessedAtFiles = new Hashtable();
    private Object[] _aoPackage = null;
    private String _sJavaSourceFileName = null;

    private DataInputStream createInputStream(String sSourceFileName_) {
        DataInputStream disSource = null;
        try {
            disSource = new DataInputStream(new FileInputStream(sSourceFileName_));
        }
        catch (IOException pIOException) {
            this._sErrorMessage = Util.isEmpty(this._sErrorMessage) ? "" : this._sErrorMessage + "\n";
            this._sErrorMessage = this._sErrorMessage + "File not found: " + sSourceFileName_;
            this._thrwError = pIOException;
            return null;
        }
        return disSource;
    }

    private void _measureSource(String sSourceFileName_) throws IOException, ParseException, TokenMgrError {
        sSourceFileName_ = FileUtil.normalizeFileName(sSourceFileName_);
        DataInputStream disSource = null;
        try {
            disSource = new DataInputStream(new FileInputStream(sSourceFileName_));
        }
        catch (IOException pIOException) {
            this._sErrorMessage = Util.isEmpty(this._sErrorMessage) ? "" : this._sErrorMessage + "\n";
            this._sErrorMessage = this._sErrorMessage + "File not found: " + sSourceFileName_;
            this._thrwError = pIOException;
            throw pIOException;
        }
        String sTempErrorMessage = this._sErrorMessage;
        try {
            this._measureSource(disSource);
        }
        catch (ParseException pParseException) {
            if (sTempErrorMessage == null) {
                sTempErrorMessage = "";
            }
            sTempErrorMessage = sTempErrorMessage + "ParseException in " + sSourceFileName_ + "\nLast useful checkpoint: \"" + this._pJavaParser.getLastFunction() + "\"\n";
            this._sErrorMessage = sTempErrorMessage = sTempErrorMessage + pParseException.getMessage() + "\n";
            this._thrwError = pParseException;
            throw pParseException;
        }
        catch (TokenMgrError pTokenMgrError) {
            if (sTempErrorMessage == null) {
                sTempErrorMessage = "";
            }
            this._sErrorMessage = sTempErrorMessage = sTempErrorMessage + "TokenMgrError in " + sSourceFileName_ + "\n" + pTokenMgrError.getMessage() + "\n";
            this._thrwError = pTokenMgrError;
            throw pTokenMgrError;
        }
    }

    private void _measureSource(DataInputStream disSource_) throws IOException, ParseException, TokenMgrError {
        try {
            this._pJavaParser = new JavaParser(disSource_);
            this._pJavaParser.CompilationUnit();
            this._ncss += this._pJavaParser.getNcss();
            this._loc += this._pJavaParser.getLOC();
            this._vFunctionMetrics.addAll(this._pJavaParser.getFunction());
            this._vObjectMetrics.addAll(this._pJavaParser.getObject());
            Hashtable htNewPackages = this._pJavaParser.getPackage();
            Enumeration ePackages = htNewPackages.keys();
            while (ePackages.hasMoreElements()) {
                String sPackage = (String)ePackages.nextElement();
                PackageMetric pckmNext = (PackageMetric)htNewPackages.get(sPackage);
                pckmNext.name = sPackage;
                PackageMetric pckmPrevious = (PackageMetric)this._htPackages.get(sPackage);
                pckmNext.add(pckmPrevious);
                this._htPackages.put(sPackage, pckmNext);
            }
        }
        catch (ParseException pParseException) {
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "ParseException in STDIN";
            if (this._pJavaParser != null) {
                this._sErrorMessage = this._sErrorMessage + "\nLast useful checkpoint: \"" + this._pJavaParser.getLastFunction() + "\"\n";
            }
            this._sErrorMessage = this._sErrorMessage + pParseException.getMessage() + "\n";
            this._thrwError = pParseException;
            throw pParseException;
        }
        catch (TokenMgrError pTokenMgrError) {
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "TokenMgrError in STDIN\n";
            this._sErrorMessage = this._sErrorMessage + pTokenMgrError.getMessage() + "\n";
            this._thrwError = pTokenMgrError;
            throw pTokenMgrError;
        }
    }

    private void _measureFiles(Vector vJavaSourceFiles_) throws IOException, ParseException, TokenMgrError {
        Enumeration e = vJavaSourceFiles_.elements();
        while (e.hasMoreElements()) {
            String sJavaFileName = (String)e.nextElement();
            if (sJavaFileName.charAt(0) == '@') {
                if (sJavaFileName.length() <= 1) continue;
                String sFileName = sJavaFileName.substring(1);
                if (this._htProcessedAtFiles.get(sFileName = FileUtil.normalizeFileName(sFileName)) != null) continue;
                this._htProcessedAtFiles.put(sFileName, sFileName);
                String sJavaSourceFileNames = null;
                try {
                    sJavaSourceFileNames = FileUtil.readFile(sFileName);
                }
                catch (IOException pIOException) {
                    this._sErrorMessage = "File Read Error: " + sFileName;
                    this._thrwError = pIOException;
                    throw pIOException;
                }
                Vector vTheseJavaSourceFiles = Util.stringToLines(sJavaSourceFileNames);
                this._measureFiles(vTheseJavaSourceFiles);
                continue;
            }
            try {
                this._measureSource(sJavaFileName);
            }
            catch (Throwable pThrowable) {}
        }
    }

    private void _measureRoot(InputStream pInputStream_) throws IOException, ParseException, TokenMgrError {
        this._htPackages = new Hashtable();
        if (this._vJavaSourceFiles.size() == 0) {
            DataInputStream disJava = new DataInputStream(pInputStream_);
            this._measureSource(disJava);
        } else {
            this._measureFiles(this._vJavaSourceFiles);
        }
        this._vPackageMetrics = new Vector();
        Enumeration ePackages = this._htPackages.keys();
        while (ePackages.hasMoreElements()) {
            String sPackage = (String)ePackages.nextElement();
            PackageMetric pckmNext = (PackageMetric)this._htPackages.get(sPackage);
            this._vPackageMetrics.addElement(pckmNext);
        }
    }

    public Vector getImports() {
        return this._vImports;
    }

    public Object[] getPackage() {
        return this._aoPackage;
    }

    public Vector getFunctions() {
        return this._vFunctionMetrics;
    }

    public Javancss(Vector vJavaSourceFiles_) {
        this._vJavaSourceFiles = vJavaSourceFiles_;
        try {
            this._measureRoot(System.in);
        }
        catch (Exception e) {
        }
        catch (TokenMgrError tokenMgrError) {
            // empty catch block
        }
    }

    public Javancss(String sJavaSourceFile_) {
        this._sErrorMessage = null;
        this._vJavaSourceFiles = new Vector();
        this._vJavaSourceFiles.addElement(sJavaSourceFile_);
        try {
            this._measureRoot(System.in);
        }
        catch (Exception e) {
            System.out.println("Javancss.<init>(String).e: " + e);
        }
        catch (TokenMgrError pError) {
            System.out.println("Javancss.<init>(String).pError: " + pError);
        }
    }

    public Javancss(InputStream isJavaSource_) {
        this._sErrorMessage = null;
        this._vJavaSourceFiles = new Vector();
        try {
            this._measureRoot(isJavaSource_);
        }
        catch (Exception e) {
            System.out.println("Javancss.<init>(InputStream).e: " + e);
        }
        catch (TokenMgrError pError) {
            System.out.println("Javancss.<init>(InputStream).pError: " + pError);
        }
    }

    public Javancss() {
        this._sErrorMessage = null;
        this._thrwError = null;
    }

    public boolean parseImports() {
        if (Util.isEmpty(this._sJavaSourceFileName)) {
            System.out.println("Javancss.parseImports().NO_FILE");
            return true;
        }
        DataInputStream disSource = this.createInputStream(this._sJavaSourceFileName);
        if (disSource == null) {
            System.out.println("Javancss.parseImports().NO_DIS");
            return true;
        }
        try {
            this._pJavaParser = new JavaParser(disSource);
            this._pJavaParser.ImportUnit();
            this._vImports = this._pJavaParser.getImports();
            this._aoPackage = this._pJavaParser.getPackageObjects();
        }
        catch (ParseException pParseException) {
            System.out.println("Javancss.parseImports().PARSE_EXCEPTION");
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "ParseException in STDIN";
            if (this._pJavaParser != null) {
                this._sErrorMessage = this._sErrorMessage + "\nLast useful checkpoint: \"" + this._pJavaParser.getLastFunction() + "\"\n";
            }
            this._sErrorMessage = this._sErrorMessage + pParseException.getMessage() + "\n";
            this._thrwError = pParseException;
            return true;
        }
        catch (TokenMgrError pTokenMgrError) {
            System.out.println("Javancss.parseImports().TOKEN_ERROR");
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "TokenMgrError in STDIN\n";
            this._sErrorMessage = this._sErrorMessage + pTokenMgrError.getMessage() + "\n";
            this._thrwError = pTokenMgrError;
            return true;
        }
        return false;
    }

    public void setSourceFile(String sJavaSourceFile_) {
        this._sJavaSourceFileName = sJavaSourceFile_;
        this._vJavaSourceFiles = new Vector();
        this._vJavaSourceFiles.addElement(sJavaSourceFile_);
    }

    public int getNcss() {
        return this._ncss;
    }

    public int getLOC() {
        return this._loc;
    }

    public int getJvdc() {
        return this._pJavaParser.getJvdc();
    }

    public int getJdcl() {
        return JavaParserTokenManager._iFormalComments;
    }

    public int getSl() {
        return JavaParserTokenManager._iSingleComments;
    }

    public int getMl() {
        return JavaParserTokenManager._iMultiComments;
    }

    public Vector getFunctionMetrics() {
        return this._vFunctionMetrics;
    }

    public Vector getObjectMetrics() {
        return this._vObjectMetrics;
    }

    public Vector getPackageMetrics() {
        return this._vPackageMetrics;
    }

    public String getLastErrorMessage() {
        if (this._sErrorMessage == null) {
            return null;
        }
        return new String(this._sErrorMessage);
    }

    public Throwable getLastError() {
        return this._thrwError;
    }
}

