/*
 * Decompiled with CFR 0.152.
 */
package play.modules.cobertura;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.instrument.ClassInstrumenter;
import net.sourceforge.cobertura.reporting.Main;
import net.sourceforge.cobertura.util.FileLocker;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.mvc.Router;
import play.vfs.VirtualFile;

public class CoberturaPlugin
extends PlayPlugin {
    public static final String DEFAULT_SILENT_MODE = "true";
    public static final String TEST_DIRECTORY = "test-result";
    public static final String REPORT_DIRECTORY = "code-coverage";
    private static int unsavedChanges = 0;
    private static boolean refreshAllClasses = false;
    public static String separator = System.getProperty("file.separator");
    static Collection ignoreRegexes = new Vector();
    static Collection ignoreBranchesRegexes = new Vector();
    static ProjectData projectData = null;
    public static File dataFile;

    public void onLoad() {
        if (!Play.id.equals("test")) {
            return;
        }
        String string = Play.configuration.getProperty("play.tmp");
        if (!"none".equals(string)) {
            Logger.warn((String)"Actually play.tmp is set to %s. Set it to play.tmp=none", (Object[])new Object[]{Play.configuration.getProperty("play.tmp")});
        }
        CoberturaPlugin.initCobertura();
        String string2 = Play.configuration.getProperty("cobertura.silent", DEFAULT_SILENT_MODE);
        boolean bl = Boolean.parseBoolean(string2);
        if (bl) {
            Logger.trace((String)"Cobertura plugin: Add Cobertura Shutdown Hook", (Object[])new Object[0]);
            Runtime.getRuntime().addShutdownHook(new CoberturaPluginShutdownThread());
        } else {
            Logger.debug((String)"Cobertura plugin: Not add Cobertura Shutdown Hook. Work with explicit call", (Object[])new Object[0]);
        }
        Logger.trace((String)"Cobertura plugin: loaded", (Object[])new Object[0]);
    }

    public void onApplicationStart() {
        if (!Play.id.equals("test")) {
            return;
        }
        this.saveCoverageData();
    }

    public void detectChange() throws RuntimeException {
        if (unsavedChanges != 0) {
            unsavedChanges = 0;
            refreshAllClasses = true;
            throw new RuntimeException();
        }
    }

    public void onConfigurationRead() {
        if (!Play.id.equals("test")) {
            return;
        }
    }

    public void onApplicationStop() {
        if (refreshAllClasses) {
            throw new RuntimeException();
        }
    }

    public void onRoutesLoaded() {
        Router.addRoute((String)"GET", (String)"/@cobertura", (String)"Cobertura.index");
        Router.addRoute((String)"GET", (String)"/@cobertura/generateReport", (String)"Cobertura.generateReport");
        Router.addRoute((String)"GET", (String)"/@cobertura/clear", (String)"Cobertura.clear");
        Router.addRoute((String)"GET", (String)"/test-result/", (String)"staticDir:test-result");
    }

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) {
        ClassWriter classWriter;
        Object object;
        Logger.trace((String)"Enhance Class on CoberturaPlugin", (Object[])new Object[0]);
        if (!Play.id.equals("test")) {
            return;
        }
        if (applicationClass.name.endsWith("Test") || applicationClass.name.equals("controllers.TestRunner")) {
            return;
        }
        String string = Play.configuration.getProperty("cobertura.ignore");
        if (string != null) {
            for (String string2 : object = string.split(",")) {
                if (!applicationClass.name.equals(string2)) continue;
                return;
            }
        }
        Logger.trace((String)"Cobertura plugin: Instrumenting class %s", (Object[])new Object[]{applicationClass.name});
        object = null;
        try {
            object = new ByteArrayInputStream(applicationClass.enhancedByteCode);
            ClassReader classReader = new ClassReader((InputStream)object);
            classWriter = new ClassWriter(1);
            ClassInstrumenter classInstrumenter = new ClassInstrumenter(projectData, (ClassVisitor)classWriter, ignoreRegexes, ignoreBranchesRegexes);
            classReader.accept((ClassVisitor)classInstrumenter, 0);
        }
        catch (Throwable throwable) {
            Logger.error((String)("Unable to instrument class " + applicationClass.name + " (" + throwable + ")"), (Object[])new Object[]{throwable});
            return;
        }
        applicationClass.enhancedByteCode = classWriter.toByteArray();
        ++unsavedChanges;
    }

    public static void initCobertura() {
        Logger.debug((String)"Cobertura plugin: initializing configuration and data", (Object[])new Object[0]);
        String string = Play.applicationPath.getAbsolutePath() + separator + "cobertura.ser";
        System.setProperty("net.sourceforge.cobertura.datafile", string);
        dataFile = CoverageDataFileHandler.getDefaultDataFile();
        if (dataFile.exists()) {
            dataFile.delete();
        }
        if (dataFile.isFile()) {
            projectData = CoverageDataFileHandler.loadCoverageData((File)dataFile);
        }
        projectData = new ProjectData();
    }

    private void saveCoverageData() {
        if (unsavedChanges > 0) {
            CoverageDataFileHandler.saveCoverageData((ProjectData)projectData, (File)dataFile);
            Logger.trace((String)"Cobertura plugin: saved coverage data for %d classes", (Object[])new Object[]{unsavedChanges});
            unsavedChanges = 0;
        }
    }

    public static void coberturaReport() {
        if (!new File(dataFile.getAbsolutePath()).exists()) {
            Logger.debug((String)"Datafile does not exist", (Object[])new Object[0]);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("--datafile");
        arrayList.add(dataFile.getAbsolutePath());
        arrayList.add("--destination");
        arrayList.add(Play.applicationPath + separator + TEST_DIRECTORY + separator + REPORT_DIRECTORY);
        arrayList.add("--format");
        arrayList.add("placeholder");
        for (VirtualFile virtualFile : Play.javaPath) {
            arrayList.add(virtualFile.getRealFile().getAbsolutePath());
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        try {
            stringArray[5] = "xml";
            Main.main((String[])stringArray);
            stringArray[5] = "html";
            Main.main((String[])stringArray);
        }
        catch (Exception exception) {
            Logger.error((String)"Error generating the Cobertura report", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String forceReportWriting() {
        Logger.debug((String)"Cobertura plugin: generating test coverage report", (Object[])new Object[0]);
        ProjectData.saveGlobalProjectData();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        FileLocker fileLocker = new FileLocker(dataFile);
        try {
            if (fileLocker.lock()) {
                Logger.trace((String)"Call coberturaReport", (Object[])new Object[0]);
                CoberturaPlugin.coberturaReport();
            } else {
                Logger.trace((String)"Cannot call coberturaReport", (Object[])new Object[0]);
            }
        }
        finally {
            fileLocker.release();
        }
        String string = new File(Play.applicationPath + separator + TEST_DIRECTORY + separator + REPORT_DIRECTORY + separator + "index.html").toURI().toString();
        Logger.info((String)"Test coverage report has been generated: %s", (Object[])new Object[]{string});
        return string;
    }

    public static String forceInit() {
        unsavedChanges = 0;
        File file = Play.tmpDir;
        if (file != null && file.exists()) {
            File file2 = new File(file.getAbsolutePath() + "/bytecode" + "/DEV");
            if (file2.exists()) {
                File[] fileArray;
                for (File file3 : fileArray = file2.listFiles()) {
                    file3.delete();
                }
            } else {
                Logger.info((String)"Tmp dir %s does not exist", (Object[])new Object[]{file2.getAbsolutePath()});
            }
        }
        CoverageDataFileHandler.saveCoverageData((ProjectData)projectData, (File)dataFile);
        Logger.info((String)"Cobertura plugin: saved coverage data for %d classes", (Object[])new Object[]{unsavedChanges});
        Play.classloader.detectChanges();
        return "";
    }

    public class CoberturaPluginShutdownThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Logger.info((String)"Cobertura plugin: generating test coverage report", (Object[])new Object[0]);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            FileLocker fileLocker = new FileLocker(dataFile);
            try {
                if (fileLocker.lock()) {
                    CoberturaPlugin.coberturaReport();
                }
            }
            finally {
                fileLocker.release();
            }
            String string = new File(Play.applicationPath + separator + CoberturaPlugin.TEST_DIRECTORY + separator + CoberturaPlugin.REPORT_DIRECTORY + separator + "index.html").toURI().toString();
            Logger.info((String)"Test coverage report has been generated: %s", (Object[])new Object[]{string});
        }
    }
}

