/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.util;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public abstract class IOUtil {
    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int el;
        if (in == null || out == null) {
            throw new NullPointerException();
        }
        byte[] buffer = new byte[32768];
        while ((el = in.read(buffer)) != -1) {
            out.write(buffer, 0, el);
        }
    }

    public static byte[] createByteArrayFromInputStream(InputStream in) throws IOException {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        IOUtil.copyStream(in, byteArray);
        return byteArray.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveFile(File sourceFile, File destinationFile) throws IOException {
        boolean succesfulMove;
        if (destinationFile.exists()) {
            destinationFile.delete();
        }
        if (succesfulMove = sourceFile.renameTo(destinationFile)) {
            return;
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(sourceFile);
            out = new FileOutputStream(destinationFile);
            IOUtil.copyStream(in, out);
        }
        catch (Throwable throwable) {
            in = IOUtil.closeInputStream(in);
            out = IOUtil.closeOutputStream(out);
            throw throwable;
        }
        in = IOUtil.closeInputStream(in);
        out = IOUtil.closeOutputStream(out);
        sourceFile.delete();
    }

    public static InputStream closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
                in = null;
            }
            catch (IOException e) {
                System.err.println("Cobertura: Error closing input stream.");
                e.printStackTrace();
            }
        }
        return in;
    }

    public static OutputStream closeOutputStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
                out = null;
            }
            catch (IOException e) {
                System.err.println("Cobertura: Error closing output stream.");
                e.printStackTrace();
            }
        }
        return out;
    }

    public static PrintWriter getPrintWriter(File file) throws UnsupportedEncodingException, FileNotFoundException {
        BufferedWriter osWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"), 16384);
        PrintWriter pw = new PrintWriter((Writer)osWriter, false);
        return pw;
    }
}

