/*
 * Decompiled with CFR 0.152.
 */
package play.modules.coffee;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jcoffeescript.JCoffeeScriptCompileException;
import org.jcoffeescript.JCoffeeScriptCompiler;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.exceptions.CompilationException;
import play.mvc.Http;
import play.templates.Template;
import play.templates.TemplateLoader;
import play.vfs.VirtualFile;

public class CoffeePlugin
extends PlayPlugin {
    private static final Pattern LINE_NUMBER = Pattern.compile("line ([0-9]+)");
    private static final ThreadLocal<JCoffeeScriptCompiler> compiler = new ThreadLocal<JCoffeeScriptCompiler>(){

        @Override
        protected JCoffeeScriptCompiler initialValue() {
            return new JCoffeeScriptCompiler();
        }
    };
    private Map<String, CompiledCoffee> cache;

    public static int getLineNumber(JCoffeeScriptCompileException e) {
        Matcher m = LINE_NUMBER.matcher(e.getMessage());
        if (m.find()) {
            return Integer.parseInt(m.group(1));
        }
        return 0;
    }

    public static JCoffeeScriptCompiler getCompiler() {
        return compiler.get();
    }

    public void onLoad() {
        this.cache = new HashMap<String, CompiledCoffee>();
    }

    public boolean serveStatic(VirtualFile file, Http.Request request, Http.Response response) {
        if (!file.getName().endsWith(".coffee")) {
            return super.serveStatic(file, request, response);
        }
        try {
            String relativePath;
            CompiledCoffee cc;
            response.contentType = "text/javascript";
            response.status = 200;
            if (Play.mode == Play.Mode.PROD) {
                response.cacheFor("1h");
            }
            if ((cc = this.cache.get(relativePath = file.relativePath())) != null && cc.sourceLastModified.equals(file.lastModified())) {
                response.print((Object)cc.output);
                return true;
            }
            String compiledCoffee = CoffeePlugin.getCompiler().compile(file.contentAsString());
            this.cache.put(relativePath, new CompiledCoffee(file.lastModified(), compiledCoffee));
            response.print((Object)compiledCoffee);
        }
        catch (JCoffeeScriptCompileException e) {
            Template tmpl = TemplateLoader.load((String)"errors/500.html");
            HashMap<String, CompilationException> args = new HashMap<String, CompilationException>();
            CompilationException ex = new CompilationException(file, e.getMessage(), CoffeePlugin.getLineNumber(e), -1, -1);
            args.put("exception", ex);
            Logger.error((Throwable)ex, (String)"Coffee compilation error", (Object[])new Object[0]);
            response.contentType = "text/html";
            response.status = 500;
            response.print((Object)tmpl.render(args));
        }
        return true;
    }

    private static final class CompiledCoffee {
        public final Long sourceLastModified;
        public final String output;

        public CompiledCoffee(Long sourceLastModified, String output) {
            this.sourceLastModified = sourceLastModified;
            this.output = output;
        }
    }
}

