/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.type.NullableType;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.jasypt.encryption.pbe.PBEByteEncryptor;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate.encryptor.HibernatePBEEncryptorRegistry;

public final class EncryptedBinaryType
implements UserType,
ParameterizedType {
    private static final int BLOCK_SIZE = 2048;
    private static NullableType nullableType = Hibernate.BINARY;
    private static int sqlType = nullableType.sqlType();
    private static int[] sqlTypes = new int[]{sqlType};
    private boolean initialized = false;
    private boolean useEncryptorName = false;
    private String encryptorName = null;
    private String algorithm = null;
    private String password = null;
    private Integer keyObtentionIterations = null;
    private PBEByteEncryptor encryptor = null;

    public int[] sqlTypes() {
        return sqlTypes;
    }

    public Class returnedClass() {
        return [B.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && y != null && Arrays.equals((byte[])x, (byte[])y);
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        byte[] valueBytes = (byte[])value;
        byte[] copyBytes = new byte[valueBytes.length];
        System.arraycopy(valueBytes, 0, copyBytes, 0, valueBytes.length);
        return copyBytes;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        return this.deepCopy(cached);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return (Serializable)this.deepCopy(value);
    }

    public boolean isMutable() {
        return true;
    }

    public int hashCode(Object x) throws HibernateException {
        byte[] valueBytes = (byte[])x;
        int result = 1;
        for (int i = 0; i < valueBytes.length; ++i) {
            result = result * 17 + valueBytes[i];
        }
        return result;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original == null ? null : this.deepCopy(original);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        this.checkInitialization();
        byte[] encryptedValue = null;
        if (Environment.useStreamsForBinary()) {
            InputStream inputStream = rs.getBinaryStream(names[0]);
            if (rs.wasNull()) {
                return null;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2048);
            byte[] inputBuff = new byte[2048];
            try {
                int readBytes = 0;
                while (readBytes != -1) {
                    readBytes = inputStream.read(inputBuff);
                    if (readBytes == -1) continue;
                    outputStream.write(inputBuff, 0, readBytes);
                }
            }
            catch (IOException e) {
                throw new HibernateException("IOException occurred reading a binary value", (Throwable)e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
            encryptedValue = outputStream.toByteArray();
        } else {
            encryptedValue = rs.getBytes(names[0]);
            if (rs.wasNull()) {
                return null;
            }
        }
        return this.encryptor.decrypt(encryptedValue);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        this.checkInitialization();
        if (value == null) {
            st.setNull(index, sqlType);
        } else {
            byte[] encryptedValue = this.encryptor.encrypt((byte[])value);
            if (Environment.useStreamsForBinary()) {
                st.setBinaryStream(index, (InputStream)new ByteArrayInputStream(encryptedValue), encryptedValue.length);
            } else {
                st.setBytes(index, encryptedValue);
            }
        }
    }

    public synchronized void setParameterValues(Properties parameters) {
        String paramEncryptorName = parameters.getProperty("encryptorRegisteredName");
        String paramAlgorithm = parameters.getProperty("algorithm");
        String paramPassword = parameters.getProperty("password");
        String paramKeyObtentionIterations = parameters.getProperty("keyObtentionIterations");
        this.useEncryptorName = false;
        if (paramEncryptorName != null) {
            if (paramAlgorithm != null || paramPassword != null || paramKeyObtentionIterations != null) {
                throw new EncryptionInitializationException("If \"encryptorRegisteredName\" is specified, none of \"algorithm\", \"password\" or \"keyObtentionIterations\" can be specified");
            }
            this.encryptorName = paramEncryptorName;
            this.useEncryptorName = true;
        } else if (paramPassword != null) {
            this.password = paramPassword;
            if (paramAlgorithm != null) {
                this.algorithm = paramAlgorithm;
            }
            if (paramKeyObtentionIterations != null) {
                try {
                    this.keyObtentionIterations = new Integer(Integer.parseInt(paramKeyObtentionIterations));
                }
                catch (NumberFormatException e) {
                    throw new EncryptionInitializationException("Value specified for \"keyObtentionIterations\" is not a valid integer");
                }
            }
        } else {
            throw new EncryptionInitializationException("If \"encryptorRegisteredName\" is not specified, then \"password\" (and optionally \"algorithm\" and \"keyObtentionIterations\") must be specified");
        }
    }

    private synchronized void checkInitialization() {
        if (!this.initialized) {
            if (this.useEncryptorName) {
                HibernatePBEEncryptorRegistry registry = HibernatePBEEncryptorRegistry.getInstance();
                PBEByteEncryptor pbeEncryptor = registry.getPBEByteEncryptor(this.encryptorName);
                if (pbeEncryptor == null) {
                    throw new EncryptionInitializationException("No big integer encryptor registered for hibernate with name \"" + this.encryptorName + "\"");
                }
                this.encryptor = pbeEncryptor;
            } else {
                StandardPBEByteEncryptor newEncryptor = new StandardPBEByteEncryptor();
                newEncryptor.setPassword(this.password);
                if (this.algorithm != null) {
                    newEncryptor.setAlgorithm(this.algorithm);
                }
                if (this.keyObtentionIterations != null) {
                    newEncryptor.setKeyObtentionIterations(this.keyObtentionIterations);
                }
                newEncryptor.initialize();
                this.encryptor = newEncryptor;
            }
            this.initialized = true;
        }
    }
}

