/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.properties;

import java.util.Properties;
import org.apache.commons.lang.Validate;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.jasypt.util.text.TextEncryptor;

public class EncryptableProperties
extends Properties {
    private static final long serialVersionUID = 6479795856725500639L;
    private final StringEncryptor stringEncryptor;
    private final TextEncryptor textEncryptor;

    public EncryptableProperties(StringEncryptor stringEncryptor) {
        this(null, stringEncryptor);
    }

    public EncryptableProperties(TextEncryptor textEncryptor) {
        this(null, textEncryptor);
    }

    public EncryptableProperties(Properties defaults, StringEncryptor stringEncryptor) {
        super(defaults);
        Validate.notNull((Object)stringEncryptor, (String)"Encryptor cannot be null");
        this.stringEncryptor = stringEncryptor;
        this.textEncryptor = null;
    }

    public EncryptableProperties(Properties defaults, TextEncryptor textEncryptor) {
        super(defaults);
        Validate.notNull((Object)textEncryptor, (String)"Encryptor cannot be null");
        this.stringEncryptor = null;
        this.textEncryptor = textEncryptor;
    }

    public String getProperty(String key) {
        return this.decode(super.getProperty(key));
    }

    public String getProperty(String key, String defaultValue) {
        return this.decode(super.getProperty(key, defaultValue));
    }

    private synchronized String decode(String encodedValue) {
        if (!PropertyValueEncryptionUtils.isEncryptedValue(encodedValue)) {
            return encodedValue;
        }
        if (this.stringEncryptor != null) {
            return PropertyValueEncryptionUtils.decrypt(encodedValue, this.stringEncryptor);
        }
        return PropertyValueEncryptionUtils.decrypt(encodedValue, this.textEncryptor);
    }
}

