/*
 * Decompiled with CFR 0.152.
 */
package play.modules.constretto;

import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.modules.constretto.Constretto;
import play.mvc.Controller;

public class ConstrettoPlugin
extends PlayPlugin {
    private static final String INJECTION_ERROR_MESSAGE = "Can not inject configuration in to Controller class %1$s because it can't be instantiated";

    public void onConfigurationRead() {
        Constretto.resetConfiguration();
        if (Logger.isDebugEnabled()) {
            Logger.debug((String)"Configuration read. ", (Object[])new Object[0]);
        }
    }

    public void onApplicationStart() {
        Constretto.reconfigure();
        this.reconfigureControllers();
    }

    public void onApplicationStop() {
        Constretto.resetConfiguration();
    }

    private void reconfigureControllers() {
        for (Class clazz : Play.classloader.getAssignableClasses(Controller.class)) {
            try {
                if (Logger.isDebugEnabled()) {
                    Logger.debug((String)"Will inject configuration in Controller class", (Object[])new Object[]{clazz.getName()});
                }
                Object controllerInstance = clazz.newInstance();
                Constretto.configure(controllerInstance);
            }
            catch (InstantiationException e) {
                Logger.warn((Throwable)e, (String)INJECTION_ERROR_MESSAGE, (Object[])new Object[]{clazz.getName()});
            }
            catch (IllegalAccessException e) {
                Logger.warn((Throwable)e, (String)INJECTION_ERROR_MESSAGE, (Object[])new Object[]{clazz.getName()});
            }
        }
    }
}

