/*
 * Decompiled with CFR 0.152.
 */
package org.constretto;

import org.constretto.ConfigurationStore;
import org.constretto.ConstrettoConfiguration;
import org.constretto.internal.provider.ConfigurationProvider;
import org.constretto.internal.resolver.DefaultConfigurationContextResolver;
import org.constretto.internal.store.EncryptedPropertiesStore;
import org.constretto.internal.store.IniFileConfigurationStore;
import org.constretto.internal.store.ObjectConfigurationStore;
import org.constretto.internal.store.PropertiesStore;
import org.constretto.internal.store.SystemPropertiesStore;
import org.constretto.resolver.ConfigurationContextResolver;
import org.springframework.core.io.Resource;

public class ConstrettoBuilder {
    private final ConfigurationProvider configurationProvider = new ConfigurationProvider();
    private final ConstrettoBuilder builder = this;

    public ConstrettoBuilder() {
        this(new DefaultConfigurationContextResolver());
    }

    public ConstrettoBuilder(ConfigurationContextResolver configurationContextResolver) {
        for (String tag : configurationContextResolver.getTags()) {
            this.addCurrentTag(tag);
        }
    }

    public ConstrettoConfiguration getConfiguration() {
        return this.configurationProvider.getConfiguration();
    }

    public ConstrettoBuilder addCurrentTag(String tag) {
        this.configurationProvider.addTag(tag);
        return this;
    }

    public ConstrettoBuilder addConfigurationStore(ConfigurationStore configurationStore) {
        this.configurationProvider.addConfigurationStore(configurationStore);
        return this;
    }

    public PropertiesStoreBuilder createPropertiesStore() {
        return new PropertiesStoreBuilder();
    }

    public EncryptedPropertiesStoreBuilder createEncryptedPropertiesStore(String passwordProperty) {
        return new EncryptedPropertiesStoreBuilder(passwordProperty);
    }

    public IniFileConfigurationStoreBuilder createIniFileConfigurationStore() {
        return new IniFileConfigurationStoreBuilder();
    }

    public ConstrettoBuilder createSystemPropertiesStore() {
        this.configurationProvider.addConfigurationStore(new SystemPropertiesStore());
        return this;
    }

    public ObjectConfigurationStoreBuilder createObjectConfigurationStore() {
        return new ObjectConfigurationStoreBuilder();
    }

    public class ObjectConfigurationStoreBuilder
    implements StoreBuilder {
        private final ObjectConfigurationStore store = new ObjectConfigurationStore();

        public ObjectConfigurationStoreBuilder addObject(Object object) {
            this.store.addObject(object);
            return this;
        }

        public ConstrettoBuilder done() {
            ConstrettoBuilder.this.configurationProvider.addConfigurationStore(this.store);
            return ConstrettoBuilder.this.builder;
        }
    }

    public class IniFileConfigurationStoreBuilder
    implements StoreBuilder {
        private final IniFileConfigurationStore store = new IniFileConfigurationStore();

        public IniFileConfigurationStoreBuilder addResource(Resource resource) {
            this.store.addResource(resource);
            return this;
        }

        public ConstrettoBuilder done() {
            ConstrettoBuilder.this.configurationProvider.addConfigurationStore(this.store);
            return ConstrettoBuilder.this.builder;
        }
    }

    public class EncryptedPropertiesStoreBuilder
    implements StoreBuilder {
        private final EncryptedPropertiesStore store;

        public EncryptedPropertiesStoreBuilder(String passwordProperty) {
            this.store = new EncryptedPropertiesStore(passwordProperty);
        }

        public EncryptedPropertiesStoreBuilder addResource(Resource resource) {
            this.store.addResource(resource);
            return this;
        }

        public ConstrettoBuilder done() {
            ConstrettoBuilder.this.configurationProvider.addConfigurationStore(this.store);
            return ConstrettoBuilder.this.builder;
        }
    }

    public class PropertiesStoreBuilder
    implements StoreBuilder {
        private final PropertiesStore store = new PropertiesStore();

        public PropertiesStoreBuilder addResource(Resource resource) {
            this.store.addResource(resource);
            return this;
        }

        public ConstrettoBuilder done() {
            ConstrettoBuilder.this.configurationProvider.addConfigurationStore(this.store);
            return ConstrettoBuilder.this.builder;
        }
    }

    private static interface StoreBuilder {
        public ConstrettoBuilder done();
    }
}

