/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.converter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.constretto.exception.ConstrettoConversionException;
import org.constretto.internal.converter.ValueConverter;
import org.springframework.core.io.DefaultResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFileValueConverter
implements ValueConverter<Properties> {
    @Override
    public Properties fromString(String resourceName) throws ConstrettoConversionException {
        try {
            Properties properties = new Properties();
            InputStream stream = new DefaultResourceLoader(this.getClass().getClassLoader()).getResource(resourceName).getInputStream();
            if (resourceName.endsWith(".xml")) {
                properties.loadFromXML(stream);
            } else {
                properties.load(stream);
            }
            return properties;
        }
        catch (IOException e) {
            throw new ConstrettoConversionException(resourceName, Properties.class, (Throwable)e);
        }
    }
}

