/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.internal.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.constretto.ConfigurationStore;
import org.constretto.ConstrettoConfiguration;
import org.constretto.internal.DefaultConstrettoConfiguration;
import org.constretto.model.ConfigurationNode;
import org.constretto.model.TaggedPropertySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationProvider {
    private ConstrettoConfiguration configuration;
    private List<ConfigurationStore> configurationStores = new ArrayList<ConfigurationStore>();
    private List<String> tags = new ArrayList<String>();

    public ConfigurationProvider addTag(String tag) {
        this.tags.add(tag);
        return this;
    }

    public ConfigurationProvider addConfigurationStore(ConfigurationStore configurationStore) {
        this.configurationStores.add(configurationStore);
        return this;
    }

    public ConstrettoConfiguration getConfiguration() {
        if (null == this.configuration) {
            this.configuration = this.buildConfiguration();
        }
        return this.configuration;
    }

    private ConstrettoConfiguration buildConfiguration() {
        ConfigurationNode rootNode = ConfigurationNode.createRootElement();
        Collection<TaggedPropertySet> taggedPropertySets = this.loadPropertySets();
        for (TaggedPropertySet taggedPropertySet : taggedPropertySets) {
            Map<String, String> properties = taggedPropertySet.getProperties();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                rootNode.update(entry.getKey(), entry.getValue(), taggedPropertySet.getTag());
            }
        }
        return new DefaultConstrettoConfiguration(rootNode, this.tags);
    }

    private Collection<TaggedPropertySet> loadPropertySets() {
        ArrayList<TaggedPropertySet> taggedPropertySets = new ArrayList<TaggedPropertySet>();
        for (ConfigurationStore configurationStore : this.configurationStores) {
            taggedPropertySets.addAll(configurationStore.parseConfiguration());
        }
        return taggedPropertySets;
    }
}

