/*
 * Decompiled with CFR 0.152.
 */
package org.constretto.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationNode {
    public static final String DEFAULT_TAG = "[default-tag]";
    public static final String ALL_TAG = "[all-tag]";
    private static final String ROOT_ELEMENT_NAME = "root-element";
    private final String name;
    private final String tag;
    private final List<ConfigurationNode> children = new ArrayList<ConfigurationNode>();
    private ConfigurationNode parent;
    private String value;

    public static ConfigurationNode createRootElement() {
        return new ConfigurationNode();
    }

    public static void createRootElementOf(ConfigurationNode currentConfigurationNode) {
        ConfigurationNode newRoot = new ConfigurationNode();
        for (ConfigurationNode childNode : currentConfigurationNode.children) {
            newRoot.addChild(childNode);
        }
    }

    public ConfigurationNode root() {
        ConfigurationNode currentNode = this;
        while (currentNode.parent != null) {
            currentNode = currentNode.parent;
        }
        return currentNode;
    }

    private ConfigurationNode() {
        this.name = ROOT_ELEMENT_NAME;
        this.tag = DEFAULT_TAG;
    }

    private ConfigurationNode(String name, String tag, String value) {
        this.name = name;
        this.tag = tag;
        this.value = value;
    }

    private ConfigurationNode(String name) {
        this.name = name;
        this.tag = DEFAULT_TAG;
    }

    public String getValue() {
        return this.value;
    }

    public void updateValue(String value) {
        this.value = value;
    }

    public String getTag() {
        return this.tag;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<ConfigurationNode> children() {
        return this.children;
    }

    public String getExpression() {
        String expression = this.parent != null && !this.parent.name.equals(ROOT_ELEMENT_NAME) ? this.parent.getExpression() + "." + this.name : this.name;
        return expression;
    }

    public void update(String expression, String value, String tag) {
        ConfigurationNode parent = this;
        String name = expression;
        if (expression.contains(".")) {
            parent = this.findOrCreateParent(expression.substring(0, expression.lastIndexOf(".")));
            name = expression.substring(expression.lastIndexOf(".") + 1, expression.length());
        }
        ConfigurationNode leaf = new ConfigurationNode(name, tag, value);
        parent.addChild(leaf);
    }

    public List<ConfigurationNode> findAllBy(String expression) {
        ConfigurationNode currentNode = this;
        for (String subExpression : expression.split("\\.")) {
            if (!currentNode.containsChild(subExpression)) {
                return Collections.emptyList();
            }
            currentNode = currentNode.getFirstChild(subExpression);
        }
        return currentNode.parent.getAllMatchingChildren(currentNode.name);
    }

    private boolean containsChild(String name) {
        for (ConfigurationNode currentNode : this.children) {
            if (!currentNode.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    private ConfigurationNode getFirstChild(String name) {
        for (ConfigurationNode currentNode : this.children) {
            if (!currentNode.name.equals(name)) continue;
            return currentNode;
        }
        return null;
    }

    private List<ConfigurationNode> getAllMatchingChildren(String name) {
        ArrayList<ConfigurationNode> matches = new ArrayList<ConfigurationNode>();
        for (ConfigurationNode currentNode : this.children) {
            if (!currentNode.name.equals(name)) continue;
            matches.add(currentNode);
        }
        return matches;
    }

    private ConfigurationNode findOrCreateParent(String expression) {
        ConfigurationNode currentNode = this;
        for (String subExpression : expression.split("\\.")) {
            if (!currentNode.containsChild(subExpression)) {
                ConfigurationNode newNode = new ConfigurationNode(subExpression);
                currentNode.addChild(newNode);
                currentNode = newNode;
                continue;
            }
            currentNode = currentNode.getFirstChild(subExpression);
        }
        return currentNode;
    }

    private void addChild(ConfigurationNode configurationNode) {
        this.children.add(configurationNode);
        configurationNode.parent = this;
    }

    public String toString() {
        return "ConfigurationNode{expression='" + this.name + '\'' + ", value='" + this.value + '\'' + ", tag='" + this.tag + '\'' + '}';
    }
}

