/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.QueryObjectModelFactory;
import org.apache.jackrabbit.core.query.lucene.join.Constraints;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstraintSplitInfo {
    private final QueryObjectModelFactory factory;
    private final Join source;
    private final List<Constraint> leftConstraints;
    private final List<Constraint> rightConstraints;
    private boolean isMultiple;
    private ConstraintSplitInfo leftInnerConstraints = null;
    private ConstraintSplitInfo rightInnerConstraints = null;

    public ConstraintSplitInfo(QueryObjectModelFactory factory, Join source) {
        this(factory, source, new ArrayList<Constraint>(), new ArrayList<Constraint>());
    }

    private ConstraintSplitInfo(QueryObjectModelFactory factory, Join source, List<Constraint> leftConstraints, List<Constraint> rightConstraints) {
        this.factory = factory;
        this.source = source;
        this.isMultiple = false;
        this.leftConstraints = leftConstraints;
        this.rightConstraints = rightConstraints;
    }

    public void addLeftConstraint(Constraint c) {
        if (this.isMultiple) {
            this.leftInnerConstraints.addLeftConstraint(c);
            this.leftInnerConstraints.addRightConstraint(c);
            return;
        }
        this.leftConstraints.add(c);
    }

    public void addRightConstraint(Constraint c) {
        if (this.isMultiple) {
            this.rightInnerConstraints.addLeftConstraint(c);
            this.rightInnerConstraints.addRightConstraint(c);
            return;
        }
        this.rightConstraints.add(c);
    }

    public void splitOr() {
        ConstraintSplitInfo csi2;
        ConstraintSplitInfo csi1;
        if (this.isMultiple) {
            return;
        }
        this.isMultiple = true;
        this.leftInnerConstraints = csi1 = new ConstraintSplitInfo(this.factory, this.source, new ArrayList<Constraint>(this.leftConstraints), new ArrayList<Constraint>(this.rightConstraints));
        this.rightInnerConstraints = csi2 = new ConstraintSplitInfo(this.factory, this.source, new ArrayList<Constraint>(this.leftConstraints), new ArrayList<Constraint>(this.rightConstraints));
        this.leftConstraints.clear();
        this.rightConstraints.clear();
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public ConstraintSplitInfo getLeftInnerConstraints() {
        return this.leftInnerConstraints;
    }

    public ConstraintSplitInfo getRightInnerConstraints() {
        return this.rightInnerConstraints;
    }

    public Join getSource() {
        return this.source;
    }

    public Constraint getLeftConstraint() throws RepositoryException {
        return Constraints.and(this.factory, this.leftConstraints);
    }

    public Constraint getRightConstraint() throws RepositoryException {
        return Constraints.and(this.factory, this.rightConstraints);
    }

    public String toString() {
        if (this.isMultiple) {
            return "ConstraintSplitInfo [multiple=, leftInnerConstraints=" + this.leftInnerConstraints + ", rightInnerConstraints=" + this.rightInnerConstraints + "]";
        }
        return "ConstraintSplitInfo [single, leftConstraints=" + this.leftConstraints + ", rightConstraints=" + this.rightConstraints + "]";
    }
}

